/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.auth;

import java.security.SecureRandom;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.ServerPublicParams;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.auth.AuthCredential;
import org.signal.libsignal.zkgroup.auth.AuthCredentialPresentation;
import org.signal.libsignal.zkgroup.auth.AuthCredentialResponse;
import org.signal.libsignal.zkgroup.auth.AuthCredentialWithPni;
import org.signal.libsignal.zkgroup.auth.AuthCredentialWithPniResponse;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;

public class ClientZkAuthOperations {
    private final ServerPublicParams serverPublicParams;

    public ClientZkAuthOperations(ServerPublicParams serverPublicParams) {
        this.serverPublicParams = serverPublicParams;
    }

    public AuthCredential receiveAuthCredential(ServiceId.Aci aci, int redemptionTime, AuthCredentialResponse authCredentialResponse) throws VerificationFailedException {
        byte[] newContents = Native.ServerPublicParams_ReceiveAuthCredential(this.serverPublicParams.getInternalContentsForJNI(), aci.toServiceIdFixedWidthBinary(), redemptionTime, authCredentialResponse.getInternalContentsForJNI());
        try {
            return new AuthCredential(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public AuthCredentialWithPni receiveAuthCredentialWithPniAsServiceId(ServiceId.Aci aci, ServiceId.Pni pni, long redemptionTime, AuthCredentialWithPniResponse authCredentialResponse) throws VerificationFailedException {
        byte[] newContents = Native.ServerPublicParams_ReceiveAuthCredentialWithPniAsServiceId(this.serverPublicParams.getInternalContentsForJNI(), aci.toServiceIdFixedWidthBinary(), pni.toServiceIdFixedWidthBinary(), redemptionTime, authCredentialResponse.getInternalContentsForJNI());
        try {
            return new AuthCredentialWithPni(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public AuthCredentialWithPni receiveAuthCredentialWithPniAsAci(ServiceId.Aci aci, ServiceId.Pni pni, long redemptionTime, AuthCredentialWithPniResponse authCredentialResponse) throws VerificationFailedException {
        byte[] newContents = Native.ServerPublicParams_ReceiveAuthCredentialWithPniAsAci(this.serverPublicParams.getInternalContentsForJNI(), aci.toServiceIdFixedWidthBinary(), pni.toServiceIdFixedWidthBinary(), redemptionTime, authCredentialResponse.getInternalContentsForJNI());
        try {
            return new AuthCredentialWithPni(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public AuthCredentialPresentation createAuthCredentialPresentation(GroupSecretParams groupSecretParams, AuthCredential authCredential) {
        return this.createAuthCredentialPresentation(new SecureRandom(), groupSecretParams, authCredential);
    }

    public AuthCredentialPresentation createAuthCredentialPresentation(SecureRandom secureRandom, GroupSecretParams groupSecretParams, AuthCredential authCredential) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = Native.ServerPublicParams_CreateAuthCredentialPresentationDeterministic(this.serverPublicParams.getInternalContentsForJNI(), random, groupSecretParams.getInternalContentsForJNI(), authCredential.getInternalContentsForJNI());
        try {
            return new AuthCredentialPresentation(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public AuthCredentialPresentation createAuthCredentialPresentation(GroupSecretParams groupSecretParams, AuthCredentialWithPni authCredential) {
        return this.createAuthCredentialPresentation(new SecureRandom(), groupSecretParams, authCredential);
    }

    public AuthCredentialPresentation createAuthCredentialPresentation(SecureRandom secureRandom, GroupSecretParams groupSecretParams, AuthCredentialWithPni authCredential) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = Native.ServerPublicParams_CreateAuthCredentialWithPniPresentationDeterministic(this.serverPublicParams.getInternalContentsForJNI(), random, groupSecretParams.getInternalContentsForJNI(), authCredential.getInternalContentsForJNI());
        try {
            return new AuthCredentialPresentation(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }
}

