/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.groups;

import java.util.UUID;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.DuplicateMessageException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.LegacyMessageException;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.groups.state.SenderKeyStore;
import org.signal.libsignal.protocol.message.CiphertextMessage;

public class GroupCipher {
    private final SenderKeyStore senderKeyStore;
    private final SignalProtocolAddress sender;

    public GroupCipher(SenderKeyStore senderKeyStore, SignalProtocolAddress sender) {
        this.senderKeyStore = senderKeyStore;
        this.sender = sender;
    }

    public CiphertextMessage encrypt(UUID distributionId, byte[] paddedPlaintext) throws NoSessionException {
        try (NativeHandleGuard sender = new NativeHandleGuard(this.sender);){
            CiphertextMessage ciphertextMessage = Native.GroupCipher_EncryptMessage(sender.nativeHandle(), distributionId, paddedPlaintext, this.senderKeyStore);
            return ciphertextMessage;
        }
    }

    public byte[] decrypt(byte[] senderKeyMessageBytes) throws LegacyMessageException, DuplicateMessageException, InvalidMessageException, NoSessionException {
        try (NativeHandleGuard sender = new NativeHandleGuard(this.sender);){
            byte[] byArray = Native.GroupCipher_DecryptMessage(sender.nativeHandle(), senderKeyMessageBytes, this.senderKeyStore);
            return byArray;
        }
    }
}

