/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol;

import java.time.Instant;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.DuplicateMessageException;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidKeyIdException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.InvalidVersionException;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.UntrustedIdentityException;
import org.signal.libsignal.protocol.message.CiphertextMessage;
import org.signal.libsignal.protocol.message.PreKeySignalMessage;
import org.signal.libsignal.protocol.message.SignalMessage;
import org.signal.libsignal.protocol.state.IdentityKeyStore;
import org.signal.libsignal.protocol.state.KyberPreKeyStore;
import org.signal.libsignal.protocol.state.PreKeyStore;
import org.signal.libsignal.protocol.state.SessionRecord;
import org.signal.libsignal.protocol.state.SessionStore;
import org.signal.libsignal.protocol.state.SignalProtocolStore;
import org.signal.libsignal.protocol.state.SignedPreKeyStore;

public class SessionCipher {
    private final SessionStore sessionStore;
    private final IdentityKeyStore identityKeyStore;
    private final PreKeyStore preKeyStore;
    private final SignedPreKeyStore signedPreKeyStore;
    private final KyberPreKeyStore kyberPreKeyStore;
    private final SignalProtocolAddress remoteAddress;

    public SessionCipher(SessionStore sessionStore, PreKeyStore preKeyStore, SignedPreKeyStore signedPreKeyStore, KyberPreKeyStore kyberPreKeyStore, IdentityKeyStore identityKeyStore, SignalProtocolAddress remoteAddress) {
        this.sessionStore = sessionStore;
        this.preKeyStore = preKeyStore;
        this.identityKeyStore = identityKeyStore;
        this.remoteAddress = remoteAddress;
        this.signedPreKeyStore = signedPreKeyStore;
        this.kyberPreKeyStore = kyberPreKeyStore;
    }

    public SessionCipher(SignalProtocolStore store, SignalProtocolAddress remoteAddress) {
        this(store, store, store, store, store, remoteAddress);
    }

    public CiphertextMessage encrypt(byte[] paddedMessage) throws NoSessionException, UntrustedIdentityException {
        return this.encrypt(paddedMessage, Instant.now());
    }

    public CiphertextMessage encrypt(byte[] paddedMessage, Instant now) throws NoSessionException, UntrustedIdentityException {
        try (NativeHandleGuard remoteAddress = new NativeHandleGuard(this.remoteAddress);){
            CiphertextMessage ciphertextMessage = Native.SessionCipher_EncryptMessage(paddedMessage, remoteAddress.nativeHandle(), this.sessionStore, this.identityKeyStore, now.toEpochMilli());
            return ciphertextMessage;
        }
    }

    public byte[] decrypt(PreKeySignalMessage ciphertext) throws DuplicateMessageException, InvalidMessageException, InvalidKeyIdException, InvalidKeyException, UntrustedIdentityException {
        try (NativeHandleGuard ciphertextGuard = new NativeHandleGuard(ciphertext);){
            NativeHandleGuard remoteAddressGuard = new NativeHandleGuard(this.remoteAddress);
            try {
                byte[] byArray = Native.SessionCipher_DecryptPreKeySignalMessage(ciphertextGuard.nativeHandle(), remoteAddressGuard.nativeHandle(), this.sessionStore, this.identityKeyStore, this.preKeyStore, this.signedPreKeyStore, this.kyberPreKeyStore);
                remoteAddressGuard.close();
                return byArray;
            }
            catch (Throwable throwable) {
                try {
                    remoteAddressGuard.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public byte[] decrypt(SignalMessage ciphertext) throws InvalidMessageException, InvalidVersionException, DuplicateMessageException, NoSessionException, UntrustedIdentityException {
        try (NativeHandleGuard ciphertextGuard = new NativeHandleGuard(ciphertext);){
            NativeHandleGuard remoteAddressGuard = new NativeHandleGuard(this.remoteAddress);
            try {
                byte[] byArray = Native.SessionCipher_DecryptSignalMessage(ciphertextGuard.nativeHandle(), remoteAddressGuard.nativeHandle(), this.sessionStore, this.identityKeyStore);
                remoteAddressGuard.close();
                return byArray;
            }
            catch (Throwable throwable) {
                try {
                    remoteAddressGuard.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public int getRemoteRegistrationId() {
        if (!this.sessionStore.containsSession(this.remoteAddress)) {
            throw new IllegalStateException(String.format("No session for (%s)!", this.remoteAddress));
        }
        SessionRecord record = this.sessionStore.loadSession(this.remoteAddress);
        return record.getRemoteRegistrationId();
    }

    public int getSessionVersion() {
        if (!this.sessionStore.containsSession(this.remoteAddress)) {
            throw new IllegalStateException(String.format("No session for (%s)!", this.remoteAddress));
        }
        SessionRecord record = this.sessionStore.loadSession(this.remoteAddress);
        return record.getSessionVersion();
    }
}

