/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.message;

import java.util.Optional;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

public final class DecryptionErrorMessage
implements NativeHandleGuard.Owner {
    final long unsafeHandle;

    protected void finalize() {
        Native.DecryptionErrorMessage_Destroy(this.unsafeHandle);
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }

    DecryptionErrorMessage(long unsafeHandle) {
        this.unsafeHandle = unsafeHandle;
    }

    public DecryptionErrorMessage(byte[] serialized) throws InvalidMessageException {
        this.unsafeHandle = Native.DecryptionErrorMessage_Deserialize(serialized);
    }

    public static DecryptionErrorMessage forOriginalMessage(byte[] originalBytes, int messageType, long timestamp, int originalSenderDeviceId) {
        return new DecryptionErrorMessage(Native.DecryptionErrorMessage_ForOriginalMessage(originalBytes, messageType, timestamp, originalSenderDeviceId));
    }

    public byte[] serialize() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.DecryptionErrorMessage_GetSerialized(guard.nativeHandle());
            return byArray;
        }
    }

    public Optional<ECPublicKey> getRatchetKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            long keyHandle = Native.DecryptionErrorMessage_GetRatchetKey(guard.nativeHandle());
            if (keyHandle == 0L) {
                Optional<ECPublicKey> optional = Optional.empty();
                return optional;
            }
            Optional<ECPublicKey> optional = Optional.of(new ECPublicKey(keyHandle));
            return optional;
        }
    }

    public long getTimestamp() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            long l = Native.DecryptionErrorMessage_GetTimestamp(guard.nativeHandle());
            return l;
        }
    }

    public int getDeviceId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.DecryptionErrorMessage_GetDeviceId(guard.nativeHandle());
            return n;
        }
    }

    public static DecryptionErrorMessage extractFromSerializedContent(byte[] serializedContentBytes) throws InvalidMessageException {
        return new DecryptionErrorMessage(Native.DecryptionErrorMessage_ExtractFromSerializedContent(serializedContentBytes));
    }
}

