/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.message;

import java.util.UUID;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.InvalidVersionException;
import org.signal.libsignal.protocol.LegacyMessageException;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.message.CiphertextMessage;

public class SenderKeyMessage
implements CiphertextMessage,
NativeHandleGuard.Owner {
    private final long unsafeHandle;

    protected void finalize() {
        Native.SenderKeyMessage_Destroy(this.unsafeHandle);
    }

    public SenderKeyMessage(long unsafeHandle) {
        this.unsafeHandle = unsafeHandle;
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }

    public SenderKeyMessage(byte[] serialized) throws InvalidMessageException, InvalidVersionException, LegacyMessageException {
        this.unsafeHandle = Native.SenderKeyMessage_Deserialize(serialized);
    }

    public UUID getDistributionId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            UUID uUID = Native.SenderKeyMessage_GetDistributionId(guard.nativeHandle());
            return uUID;
        }
    }

    public int getChainId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.SenderKeyMessage_GetChainId(guard.nativeHandle());
            return n;
        }
    }

    public int getIteration() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.SenderKeyMessage_GetIteration(guard.nativeHandle());
            return n;
        }
    }

    public byte[] getCipherText() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.SenderKeyMessage_GetCipherText(guard.nativeHandle());
            return byArray;
        }
    }

    public void verifySignature(ECPublicKey signatureKey) throws InvalidMessageException {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);
             NativeHandleGuard keyGuard = new NativeHandleGuard(signatureKey);){
            if (!Native.SenderKeyMessage_VerifySignature(guard.nativeHandle(), keyGuard.nativeHandle())) {
                throw new InvalidMessageException("Invalid signature!");
            }
        }
    }

    @Override
    public byte[] serialize() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.SenderKeyMessage_GetSerialized(guard.nativeHandle());
            return byArray;
        }
    }

    @Override
    public int getType() {
        return 7;
    }
}

