/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.svr2;

import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;

public class PinHash
implements NativeHandleGuard.Owner {
    private final long unsafeHandle;

    private PinHash(long unsafeHandle) {
        this.unsafeHandle = unsafeHandle;
    }

    protected void finalize() {
        Native.PinHash_Destroy(this.unsafeHandle);
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }

    public static PinHash svr1(byte[] normalizedPin, byte[] salt) {
        return new PinHash(Native.PinHash_FromSalt(normalizedPin, salt));
    }

    public static PinHash svr2(byte[] normalizedPin, String username, byte[] mrenclave) {
        return new PinHash(Native.PinHash_FromUsernameMrenclave(normalizedPin, username, mrenclave));
    }

    public byte[] encryptionKey() {
        return Native.PinHash_EncryptionKey(this.unsafeHandle);
    }

    public byte[] accessKey() {
        return Native.PinHash_AccessKey(this.unsafeHandle);
    }
}

