/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.usernames;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.usernames.BaseUsernameException;

public final class Username {
    private final String username;
    private final byte[] hash;

    public Username(String username) throws BaseUsernameException {
        this.username = Objects.requireNonNull(username, "username");
        this.hash = Username.hash(username);
    }

    private Username(String username, byte[] hash) {
        this.username = username;
        this.hash = hash;
    }

    public String getUsername() {
        return this.username;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public static List<Username> candidatesFrom(String nickname, int minNicknameLength, int maxNicknameLength) throws BaseUsernameException {
        String names = Native.Username_CandidatesFrom(nickname, minNicknameLength, maxNicknameLength);
        ArrayList<Username> result = new ArrayList<Username>();
        for (String name : names.split(",")) {
            result.add(new Username(name));
        }
        return result;
    }

    public static Username fromParts(String nickname, String discriminator, int minNicknameLength, int maxNicknameLength) throws BaseUsernameException {
        byte[] hash = Native.Username_HashFromParts(nickname, discriminator, minNicknameLength, maxNicknameLength);
        String username = nickname + "." + discriminator;
        return new Username(username, hash);
    }

    public static Username fromLink(UsernameLink usernameLink) throws BaseUsernameException {
        String username = Native.UsernameLink_DecryptUsername(usernameLink.getEntropy(), usernameLink.getEncryptedUsername());
        return new Username(username);
    }

    public byte[] generateProof() throws BaseUsernameException {
        byte[] randomness = new byte[32];
        SecureRandom r = new SecureRandom();
        r.nextBytes(randomness);
        return this.generateProofWithRandomness(randomness);
    }

    public byte[] generateProofWithRandomness(byte[] randomness) throws BaseUsernameException {
        return Native.Username_Proof(this.username, randomness);
    }

    public UsernameLink generateLink() throws BaseUsernameException {
        return this.generateLink(null);
    }

    public UsernameLink generateLink(byte[] previousEntropy) throws BaseUsernameException {
        byte[] bytes = Native.UsernameLink_Create(this.username, previousEntropy);
        byte[] entropy = Arrays.copyOfRange(bytes, 0, 32);
        byte[] enctyptedUsername = Arrays.copyOfRange(bytes, 32, bytes.length);
        return new UsernameLink(entropy, enctyptedUsername);
    }

    @Deprecated
    public static List<String> generateCandidates(String nickname, int minNicknameLength, int maxNicknameLength) throws BaseUsernameException {
        String names = Native.Username_CandidatesFrom(nickname, minNicknameLength, maxNicknameLength);
        return Arrays.asList(names.split(","));
    }

    @Deprecated
    public static byte[] hash(String username) throws BaseUsernameException {
        return Native.Username_Hash(username);
    }

    @Deprecated
    public static byte[] generateProof(String username, byte[] randomness) throws BaseUsernameException {
        return Native.Username_Proof(username, randomness);
    }

    public static void verifyProof(byte[] proof, byte[] hash) throws BaseUsernameException {
        Native.Username_Verify(proof, hash);
    }

    public String toString() {
        return this.username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Username username1 = (Username)o;
        return this.username.equals(username1.username);
    }

    public int hashCode() {
        return this.username.hashCode();
    }

    public static class UsernameLink {
        private final byte[] entropy;
        private final byte[] encryptedUsername;

        public UsernameLink(byte[] entropy, byte[] encryptedUsername) {
            this.entropy = Objects.requireNonNull(entropy, "entropy");
            this.encryptedUsername = Objects.requireNonNull(encryptedUsername, "encryptedUsername");
        }

        public byte[] getEntropy() {
            return this.entropy;
        }

        public byte[] getEncryptedUsername() {
            return this.encryptedUsername;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UsernameLink that = (UsernameLink)o;
            return Arrays.equals(this.entropy, that.entropy) && Arrays.equals(this.encryptedUsername, that.encryptedUsername);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.entropy);
            result = 31 * result + Arrays.hashCode(this.encryptedUsername);
            return result;
        }
    }
}

