/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.backups;

import java.security.SecureRandom;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.GenericServerPublicParams;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.backups.BackupAuthCredentialPresentation;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class BackupAuthCredential
extends ByteArray {
    public BackupAuthCredential(byte[] contents) throws InvalidInputException {
        super(contents);
        Native.BackupAuthCredential_CheckValidContents(contents);
    }

    public BackupAuthCredentialPresentation present(GenericServerPublicParams serverParams) {
        return this.present(serverParams, new SecureRandom());
    }

    public BackupAuthCredentialPresentation present(GenericServerPublicParams serverParams, SecureRandom secureRandom) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = Native.BackupAuthCredential_PresentDeterministic(this.getInternalContentsForJNI(), serverParams.getInternalContentsForJNI(), random);
        try {
            return new BackupAuthCredentialPresentation(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public byte[] getBackupId() {
        return Native.BackupAuthCredential_GetBackupId(this.getInternalContentsForJNI());
    }
}

