/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.calllinks;

import java.time.Instant;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.GenericServerSecretParams;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.calllinks.CallLinkPublicParams;
import org.signal.libsignal.zkgroup.groups.UuidCiphertext;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class CallLinkAuthCredentialPresentation
extends ByteArray {
    public CallLinkAuthCredentialPresentation(byte[] contents) throws InvalidInputException {
        super(contents);
        Native.CallLinkAuthCredentialPresentation_CheckValidContents(contents);
    }

    public void verify(GenericServerSecretParams serverParams, CallLinkPublicParams callLinkParams) throws VerificationFailedException {
        this.verify(Instant.now(), serverParams, callLinkParams);
    }

    public void verify(Instant currentTime, GenericServerSecretParams serverParams, CallLinkPublicParams callLinkParams) throws VerificationFailedException {
        Native.CallLinkAuthCredentialPresentation_Verify(this.getInternalContentsForJNI(), currentTime.getEpochSecond(), serverParams.getInternalContentsForJNI(), callLinkParams.getInternalContentsForJNI());
    }

    public UuidCiphertext getUserId() {
        byte[] newContents = Native.CallLinkAuthCredentialPresentation_GetUserId(this.contents);
        try {
            return new UuidCiphertext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }
}

