/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.crypto;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidMessageException;

class Aes256GcmSiv
implements NativeHandleGuard.Owner {
    private final long unsafeHandle = FilterExceptions.filterExceptions(InvalidKeyException.class, () -> Native.Aes256GcmSiv_New(key));

    public Aes256GcmSiv(byte[] key) throws InvalidKeyException {
    }

    protected void finalize() {
        Native.Aes256GcmSiv_Destroy(this.unsafeHandle);
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }

    byte[] encrypt(byte[] plaintext, byte[] nonce, byte[] associated_data) {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(() -> Native.Aes256GcmSiv_Encrypt(guard.nativeHandle(), plaintext, nonce, associated_data));
            return byArray;
        }
    }

    byte[] decrypt(byte[] ciphertext, byte[] nonce, byte[] associated_data) throws InvalidMessageException {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(InvalidMessageException.class, () -> Native.Aes256GcmSiv_Decrypt(guard.nativeHandle(), ciphertext, nonce, associated_data));
            return byArray;
        }
    }
}

