/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class CompletableFuture<T>
implements Future<T> {
    private boolean completed;
    private T result;
    private Throwable exception;
    private List<ThenApplyCompleter<T>> consumers = new ArrayList<ThenApplyCompleter<T>>();

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public synchronized boolean isCancelled() {
        return false;
    }

    @Override
    public synchronized boolean isDone() {
        return this.completed;
    }

    public synchronized boolean complete(T result) {
        if (this.completed) {
            return false;
        }
        this.result = result;
        this.completed = true;
        this.notifyAll();
        for (ThenApplyCompleter<T> completer : this.consumers) {
            completer.complete.accept(result);
        }
        return true;
    }

    public synchronized boolean completeExceptionally(Throwable throwable) {
        if (this.completed) {
            return false;
        }
        if (throwable == null) {
            throwable = new AssertionError((Object)"Future failed, but no exception provided");
        }
        this.exception = throwable;
        this.completed = true;
        this.notifyAll();
        for (ThenApplyCompleter<T> completer : this.consumers) {
            completer.completeExceptionally.accept((Throwable)throwable);
        }
        return true;
    }

    @Override
    public synchronized T get() throws CancellationException, ExecutionException, InterruptedException {
        while (!this.completed) {
            this.wait();
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    @Override
    public synchronized T get(long timeout, TimeUnit unit) throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        long deadlineMillis = System.currentTimeMillis() + unit.toMillis(timeout);
        while (!this.completed) {
            long remainingMillis = deadlineMillis - System.currentTimeMillis();
            if (remainingMillis <= 0L) {
                throw new TimeoutException();
            }
            this.wait(remainingMillis);
        }
        return this.get();
    }

    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return this.addChainedFuture((future, value) -> {
            Object output;
            try {
                output = fn.apply(value);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
                return;
            }
            future.complete(output);
        }, CompletableFuture::completeExceptionally);
    }

    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletableFuture<U>> fn) {
        return this.addChainedFuture((future, value) -> {
            CompletableFuture output;
            try {
                output = (CompletableFuture)fn.apply(value);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
                return;
            }
            output.addCompleter(new ThenApplyCompleter<Object>(future::complete, future::completeExceptionally));
        }, CompletableFuture::completeExceptionally);
    }

    private <U> CompletableFuture<U> addChainedFuture(BiConsumer<CompletableFuture<U>, T> complete, BiConsumer<CompletableFuture<U>, Throwable> completeExceptionally) {
        CompletableFuture future = new CompletableFuture();
        ThenApplyCompleter<Object> completer = new ThenApplyCompleter<Object>(value -> complete.accept(future, value), exception -> completeExceptionally.accept((CompletableFuture)future, (Throwable)exception));
        this.addCompleter(completer);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCompleter(ThenApplyCompleter<T> completer) {
        Throwable exception;
        T result;
        CompletableFuture completableFuture = this;
        synchronized (completableFuture) {
            if (!this.completed) {
                this.consumers.add(completer);
                return;
            }
            result = this.result;
            exception = this.exception;
        }
        if (exception != null) {
            completer.completeExceptionally.accept(exception);
        } else {
            completer.complete.accept(result);
        }
    }

    private static class ThenApplyCompleter<T> {
        private Consumer<? super T> complete;
        private Consumer<Throwable> completeExceptionally;

        private ThenApplyCompleter(Consumer<? super T> complete, Consumer<Throwable> completeExceptionally) {
            this.complete = complete;
            this.completeExceptionally = completeExceptionally;
        }
    }
}

