/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.net.CdsiLookupRequest;
import org.signal.libsignal.net.CdsiLookupResponse;
import org.signal.libsignal.net.DurationExt;
import org.signal.libsignal.net.Network;

class CdsiLookup
implements NativeHandleGuard.Owner {
    private Network network;
    private long nativeHandle;

    public static CompletableFuture<CdsiLookup> start(Network network, String username, String password, CdsiLookupRequest request, Duration timeout) throws IOException, InterruptedException, ExecutionException {
        CdsiLookupRequest.NativeRequest nativeRequest = request.makeNative();
        try (NativeHandleGuard asyncRuntime = new NativeHandleGuard(network.getAsyncContext());){
            NativeHandleGuard connectionManager = new NativeHandleGuard(network.getConnectionManager());
            try {
                CompletableFuture<CdsiLookup> completableFuture = Native.CdsiLookup_new(asyncRuntime.nativeHandle(), connectionManager.nativeHandle(), username, password, nativeRequest.getHandle(), DurationExt.timeoutMillis(timeout)).thenApply(nativeHandle -> new CdsiLookup((long)nativeHandle, network));
                connectionManager.close();
                return completableFuture;
            }
            catch (Throwable throwable) {
                try {
                    connectionManager.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public CompletableFuture<CdsiLookupResponse> complete() {
        try (NativeHandleGuard asyncRuntime = new NativeHandleGuard(this.network.getAsyncContext());){
            NativeHandleGuard self = new NativeHandleGuard(this);
            try {
                CompletableFuture<CdsiLookupResponse> completableFuture = Native.CdsiLookup_complete(asyncRuntime.nativeHandle(), self.nativeHandle()).thenApply(response -> (CdsiLookupResponse)response);
                self.close();
                return completableFuture;
            }
            catch (Throwable throwable) {
                try {
                    self.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public byte[] getToken() {
        return Native.CdsiLookup_token(this.nativeHandle);
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.nativeHandle;
    }

    private CdsiLookup(long nativeHandle, Network network) {
        this.nativeHandle = nativeHandle;
        this.network = network;
    }

    protected void finalize() {
        Native.CdsiLookup_Destroy(this.nativeHandle);
    }
}

