/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import java.time.Duration;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.net.DurationExt;
import org.signal.libsignal.net.EnclaveAuth;
import org.signal.libsignal.net.Network;

public final class Svr3 {
    private Network network;

    Svr3(Network network) {
        this.network = network;
    }

    public final CompletableFuture<byte[]> backup(byte[] what, String password, int maxTries, EnclaveAuth auth, Duration timeout) {
        try (NativeHandleGuard asyncRuntime = new NativeHandleGuard(this.network.getAsyncContext());){
            NativeHandleGuard connectionManager = new NativeHandleGuard(this.network.getConnectionManager());
            try {
                CompletableFuture<byte[]> completableFuture = Native.Svr3Backup(asyncRuntime.nativeHandle(), connectionManager.nativeHandle(), what, password, maxTries, auth.username, auth.password, DurationExt.timeoutMillis(timeout));
                connectionManager.close();
                return completableFuture;
            }
            catch (Throwable throwable) {
                try {
                    connectionManager.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public final CompletableFuture<byte[]> restore(String password, byte[] shareSet, EnclaveAuth auth, Duration timeout) {
        try (NativeHandleGuard asyncRuntime = new NativeHandleGuard(this.network.getAsyncContext());){
            NativeHandleGuard connectionManager = new NativeHandleGuard(this.network.getConnectionManager());
            try {
                CompletableFuture<byte[]> completableFuture = Native.Svr3Restore(asyncRuntime.nativeHandle(), connectionManager.nativeHandle(), password, shareSet, auth.username, auth.password, DurationExt.timeoutMillis(timeout));
                connectionManager.close();
                return completableFuture;
            }
            catch (Throwable throwable) {
                try {
                    connectionManager.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

