/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.groups;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class UuidCiphertext
extends ByteArray {
    public UuidCiphertext(byte[] contents) throws InvalidInputException {
        super(contents);
        FilterExceptions.filterExceptions(InvalidInputException.class, () -> Native.UuidCiphertext_CheckValidContents(contents));
    }

    public static byte[] serializeAndConcatenate(List<UuidCiphertext> ciphertexts) {
        ByteArrayOutputStream concatenated = new ByteArrayOutputStream();
        for (UuidCiphertext member : ciphertexts) {
            try {
                concatenated.write(member.getInternalContentsForJNI());
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return concatenated.toByteArray();
    }
}

