/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.profiles;

import java.security.SecureRandom;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.ServerSecretParams;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.groups.GroupPublicParams;
import org.signal.libsignal.zkgroup.profiles.ExpiringProfileKeyCredentialResponse;
import org.signal.libsignal.zkgroup.profiles.ProfileKeyCommitment;
import org.signal.libsignal.zkgroup.profiles.ProfileKeyCredentialPresentation;
import org.signal.libsignal.zkgroup.profiles.ProfileKeyCredentialRequest;

public class ServerZkProfileOperations {
    private final ServerSecretParams serverSecretParams;

    public ServerZkProfileOperations(ServerSecretParams serverSecretParams) {
        this.serverSecretParams = serverSecretParams;
    }

    public ExpiringProfileKeyCredentialResponse issueExpiringProfileKeyCredential(ProfileKeyCredentialRequest profileKeyCredentialRequest, ServiceId.Aci userId, ProfileKeyCommitment profileKeyCommitment, Instant expiration) throws VerificationFailedException {
        return this.issueExpiringProfileKeyCredential(new SecureRandom(), profileKeyCredentialRequest, userId, profileKeyCommitment, expiration);
    }

    public ExpiringProfileKeyCredentialResponse issueExpiringProfileKeyCredential(SecureRandom secureRandom, ProfileKeyCredentialRequest profileKeyCredentialRequest, ServiceId.Aci userId, ProfileKeyCommitment profileKeyCommitment, Instant expiration) throws VerificationFailedException {
        assert (expiration.equals(expiration.truncatedTo(ChronoUnit.DAYS)));
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = FilterExceptions.filterExceptions(VerificationFailedException.class, () -> Native.ServerSecretParams_IssueExpiringProfileKeyCredentialDeterministic(this.serverSecretParams.getInternalContentsForJNI(), random, profileKeyCredentialRequest.getInternalContentsForJNI(), userId.toServiceIdFixedWidthBinary(), profileKeyCommitment.getInternalContentsForJNI(), expiration.getEpochSecond()));
        try {
            return new ExpiringProfileKeyCredentialResponse(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void verifyProfileKeyCredentialPresentation(GroupPublicParams groupPublicParams, ProfileKeyCredentialPresentation profileKeyCredentialPresentation) throws VerificationFailedException {
        this.verifyProfileKeyCredentialPresentation(groupPublicParams, profileKeyCredentialPresentation, Instant.now());
    }

    public void verifyProfileKeyCredentialPresentation(GroupPublicParams groupPublicParams, ProfileKeyCredentialPresentation profileKeyCredentialPresentation, Instant now) throws VerificationFailedException {
        FilterExceptions.filterExceptions(VerificationFailedException.class, () -> Native.ServerSecretParams_VerifyProfileKeyCredentialPresentation(this.serverSecretParams.getInternalContentsForJNI(), groupPublicParams.getInternalContentsForJNI(), profileKeyCredentialPresentation.getInternalContentsForJNI(), now.getEpochSecond()));
    }
}

