/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.backups;

import java.time.Instant;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.GenericServerSecretParams;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class BackupAuthCredentialPresentation
extends ByteArray {
    public BackupAuthCredentialPresentation(byte[] contents) throws InvalidInputException {
        super(contents);
        FilterExceptions.filterExceptions(InvalidInputException.class, () -> Native.BackupAuthCredentialPresentation_CheckValidContents(contents));
    }

    public void verify(GenericServerSecretParams serverParams) throws VerificationFailedException {
        this.verify(Instant.now(), serverParams);
    }

    public void verify(Instant currentTime, GenericServerSecretParams serverParams) throws VerificationFailedException {
        FilterExceptions.filterExceptions(VerificationFailedException.class, () -> Native.BackupAuthCredentialPresentation_Verify(this.getInternalContentsForJNI(), currentTime.getEpochSecond(), serverParams.getInternalContentsForJNI()));
    }

    public byte[] getBackupId() {
        return Native.BackupAuthCredentialPresentation_GetBackupId(this.getInternalContentsForJNI());
    }

    public long getReceiptLevel() {
        return Native.BackupAuthCredentialPresentation_GetReceiptLevel(this.getInternalContentsForJNI());
    }
}

