/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.backups;

import java.util.UUID;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.GenericServerPublicParams;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.backups.BackupAuthCredential;
import org.signal.libsignal.zkgroup.backups.BackupAuthCredentialRequest;
import org.signal.libsignal.zkgroup.backups.BackupAuthCredentialResponse;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class BackupAuthCredentialRequestContext
extends ByteArray {
    public BackupAuthCredentialRequestContext(byte[] contents) throws InvalidInputException {
        super(contents);
        FilterExceptions.filterExceptions(InvalidInputException.class, () -> Native.BackupAuthCredentialRequestContext_CheckValidContents(contents));
    }

    public static BackupAuthCredentialRequestContext create(byte[] backupKey, UUID aci) {
        byte[] newContents = Native.BackupAuthCredentialRequestContext_New(backupKey, aci);
        try {
            return new BackupAuthCredentialRequestContext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public BackupAuthCredentialRequest getRequest() {
        byte[] newContents = Native.BackupAuthCredentialRequestContext_GetRequest(this.contents);
        try {
            return new BackupAuthCredentialRequest(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public BackupAuthCredential receiveResponse(BackupAuthCredentialResponse response, GenericServerPublicParams params, long expectedReceiptLevel) throws VerificationFailedException {
        byte[] newContents = FilterExceptions.filterExceptions(VerificationFailedException.class, () -> Native.BackupAuthCredentialRequestContext_ReceiveResponse(this.getInternalContentsForJNI(), response.getInternalContentsForJNI(), params.getInternalContentsForJNI(), expectedReceiptLevel));
        try {
            return new BackupAuthCredential(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }
}

