/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.groupsend;

import java.security.SecureRandom;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.ServerPublicParams;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.signal.libsignal.zkgroup.groups.UuidCiphertext;
import org.signal.libsignal.zkgroup.groupsend.GroupSendDerivedKeyPair;
import org.signal.libsignal.zkgroup.groupsend.GroupSendEndorsement;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class GroupSendEndorsementsResponse
extends ByteArray {
    public GroupSendEndorsementsResponse(byte[] contents) throws InvalidInputException {
        super(contents);
        FilterExceptions.filterExceptions(InvalidInputException.class, () -> Native.GroupSendEndorsementsResponse_CheckValidContents(contents));
    }

    public static GroupSendEndorsementsResponse issue(Collection<UuidCiphertext> groupMembers, GroupSendDerivedKeyPair keyPair) {
        return GroupSendEndorsementsResponse.issue(groupMembers, keyPair, new SecureRandom());
    }

    public static GroupSendEndorsementsResponse issue(Collection<UuidCiphertext> groupMembers, GroupSendDerivedKeyPair keyPair, SecureRandom secureRandom) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = FilterExceptions.filterExceptions(() -> Native.GroupSendEndorsementsResponse_IssueDeterministic(UuidCiphertext.serializeAndConcatenate(groupMembers), keyPair.getInternalContentsForJNI(), random));
        return FilterExceptions.filterExceptions(() -> new GroupSendEndorsementsResponse(newContents));
    }

    public Instant getExpiration() {
        return Instant.ofEpochSecond(Native.GroupSendEndorsementsResponse_GetExpiration(this.getInternalContentsForJNI()));
    }

    public ReceivedEndorsements receive(List<ServiceId> groupMembers, ServiceId.Aci localUser, GroupSecretParams groupParams, ServerPublicParams serverParams) throws VerificationFailedException {
        return this.receive(groupMembers, localUser, Instant.now(), groupParams, serverParams);
    }

    public ReceivedEndorsements receive(List<ServiceId> groupMembers, ServiceId.Aci localUser, Instant now, GroupSecretParams groupParams, ServerPublicParams serverParams) throws VerificationFailedException {
        byte[][] endorsementContents = FilterExceptions.filterExceptions(VerificationFailedException.class, () -> Native.GroupSendEndorsementsResponse_ReceiveAndCombineWithServiceIds(this.getInternalContentsForJNI(), ServiceId.toConcatenatedFixedWidthBinary(groupMembers), localUser.toServiceIdFixedWidthBinary(), now.getEpochSecond(), groupParams.getInternalContentsForJNI(), serverParams.getInternalContentsForJNI()));
        ArrayList<GroupSendEndorsement> endorsements = new ArrayList<GroupSendEndorsement>(endorsementContents.length - 1);
        for (int i = 0; i < endorsementContents.length - 1; ++i) {
            endorsements.add(new GroupSendEndorsement(endorsementContents[i], ByteArray.UNCHECKED_AND_UNCLONED));
        }
        GroupSendEndorsement combinedEndorsement = new GroupSendEndorsement(endorsementContents[endorsementContents.length - 1], ByteArray.UNCHECKED_AND_UNCLONED);
        return new ReceivedEndorsements(endorsements, combinedEndorsement);
    }

    public ReceivedEndorsements receive(List<UuidCiphertext> groupMembers, UuidCiphertext localUser, ServerPublicParams serverParams) throws VerificationFailedException {
        return this.receive(groupMembers, localUser, Instant.now(), serverParams);
    }

    public ReceivedEndorsements receive(List<UuidCiphertext> groupMembers, UuidCiphertext localUser, Instant now, ServerPublicParams serverParams) throws VerificationFailedException {
        byte[][] endorsementContents = FilterExceptions.filterExceptions(VerificationFailedException.class, () -> Native.GroupSendEndorsementsResponse_ReceiveAndCombineWithCiphertexts(this.getInternalContentsForJNI(), UuidCiphertext.serializeAndConcatenate(groupMembers), localUser.getInternalContentsForJNI(), now.getEpochSecond(), serverParams.getInternalContentsForJNI()));
        ArrayList<GroupSendEndorsement> endorsements = new ArrayList<GroupSendEndorsement>(endorsementContents.length - 1);
        for (int i = 0; i < endorsementContents.length - 1; ++i) {
            endorsements.add(new GroupSendEndorsement(endorsementContents[i], ByteArray.UNCHECKED_AND_UNCLONED));
        }
        GroupSendEndorsement combinedEndorsement = new GroupSendEndorsement(endorsementContents[endorsementContents.length - 1], ByteArray.UNCHECKED_AND_UNCLONED);
        return new ReceivedEndorsements(endorsements, combinedEndorsement);
    }

    public record ReceivedEndorsements(List<GroupSendEndorsement> endorsements, GroupSendEndorsement combinedEndorsement) {
    }
}

