/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.internal;

import java.util.Arrays;
import java.util.Locale;
import org.signal.libsignal.zkgroup.InvalidInputException;

public abstract class ByteArray {
    public static final UncheckedAndUncloned UNCHECKED_AND_UNCLONED = UncheckedAndUncloned.UNCHECKED_AND_UNCLONED;
    protected final byte[] contents;

    protected ByteArray(byte[] contents) {
        this.contents = (byte[])contents.clone();
    }

    protected ByteArray(byte[] contents, UncheckedAndUncloned marker) {
        this.contents = contents;
    }

    protected ByteArray(byte[] contents, int expectedLength) throws InvalidInputException {
        this.contents = ByteArray.cloneArrayOfLength(contents, expectedLength);
    }

    private static byte[] cloneArrayOfLength(byte[] bytes, int expectedLength) throws InvalidInputException {
        if (bytes.length != expectedLength) {
            throw new InvalidInputException(String.format(Locale.US, "Length of array supplied was %d expected %d", bytes.length, expectedLength));
        }
        return (byte[])bytes.clone();
    }

    public byte[] getInternalContentsForJNI() {
        return this.contents;
    }

    public byte[] serialize() {
        return (byte[])this.contents.clone();
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + Arrays.hashCode(this.contents);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArray other = (ByteArray)o;
        if (this.contents == other.getInternalContentsForJNI()) {
            return true;
        }
        if (this.contents.length != other.getInternalContentsForJNI().length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < this.contents.length; ++i) {
            result |= this.contents[i] ^ other.getInternalContentsForJNI()[i];
        }
        return result == 0;
    }

    public static enum UncheckedAndUncloned {
        UNCHECKED_AND_UNCLONED;

    }
}

