/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.ecc;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

public class ECPrivateKey
implements NativeHandleGuard.Owner {
    private final long unsafeHandle;

    static ECPrivateKey generate() {
        return new ECPrivateKey(Native.ECPrivateKey_Generate());
    }

    ECPrivateKey(byte[] privateKey) throws InvalidKeyException {
        this.unsafeHandle = FilterExceptions.filterExceptions(InvalidKeyException.class, () -> Native.ECPrivateKey_Deserialize(privateKey));
    }

    public ECPrivateKey(long nativeHandle) {
        if (nativeHandle == 0L) {
            throw new NullPointerException();
        }
        this.unsafeHandle = nativeHandle;
    }

    protected void finalize() {
        Native.ECPrivateKey_Destroy(this.unsafeHandle);
    }

    public byte[] serialize() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(() -> Native.ECPrivateKey_Serialize(guard.nativeHandle()));
            return byArray;
        }
    }

    public byte[] calculateSignature(byte[] message) {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(() -> Native.ECPrivateKey_Sign(guard.nativeHandle(), message));
            return byArray;
        }
    }

    public byte[] calculateAgreement(ECPublicKey other) {
        try (NativeHandleGuard privateKey = new NativeHandleGuard(this);){
            NativeHandleGuard publicKey = new NativeHandleGuard(other);
            try {
                byte[] byArray = FilterExceptions.filterExceptions(() -> Native.ECPrivateKey_Agree(privateKey.nativeHandle(), publicKey.nativeHandle()));
                publicKey.close();
                return byArray;
            }
            catch (Throwable throwable) {
                try {
                    publicKey.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }

    public ECPublicKey publicKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            ECPublicKey eCPublicKey = new ECPublicKey(FilterExceptions.filterExceptions(() -> Native.ECPrivateKey_GetPublicKey(guard.nativeHandle())));
            return eCPublicKey;
        }
    }
}

