/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.messagebackup;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.messagebackup.MessageBackupKey;
import org.signal.libsignal.messagebackup.ValidationError;
import org.signal.libsignal.protocol.util.Pair;

public class MessageBackup {
    public static ValidationResult validate(MessageBackupKey key, Purpose purpose, Supplier<InputStream> streamFactory, long streamLength) throws ValidationError, IOException {
        Pair result;
        InputStream first = streamFactory.get();
        InputStream second = streamFactory.get();
        try (NativeHandleGuard keyGuard = new NativeHandleGuard(key);){
            Pair outputPair;
            Object output = FilterExceptions.filterExceptions(IOException.class, ValidationError.class, () -> Native.MessageBackupValidator_Validate(keyGuard.nativeHandle(), first, second, streamLength, purpose.value));
            result = outputPair = (Pair)output;
        }
        String errorMessage = (String)result.first();
        if (errorMessage != null) {
            throw new ValidationError(errorMessage, (String[])result.second());
        }
        return new ValidationResult((String[])result.second());
    }

    public static enum Purpose {
        DEVICE_TRANSFER(0),
        REMOTE_BACKUP(1);

        private final int value;

        private Purpose(int value) {
            this.value = value;
        }
    }

    public static class ValidationResult {
        public String[] unknownFieldMessages;

        public ValidationResult(String[] unknownFieldMessages) {
            this.unknownFieldMessages = unknownFieldMessages;
        }
    }
}

