/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.net.CdsiLookup;
import org.signal.libsignal.net.CdsiLookupRequest;
import org.signal.libsignal.net.CdsiLookupResponse;
import org.signal.libsignal.net.ChatService;
import org.signal.libsignal.net.Svr3;
import org.signal.libsignal.net.TokioAsyncContext;

public class Network {
    private final TokioAsyncContext tokioAsyncContext = new TokioAsyncContext();
    private final ConnectionManager connectionManager;
    private final Svr3 svr3;

    public Network(Environment env, String userAgent) {
        this.connectionManager = new ConnectionManager(env, userAgent);
        this.svr3 = new Svr3(this);
    }

    public void setProxy(String host, int port) throws IOException {
        this.connectionManager.setProxy(host, port);
    }

    public void clearProxy() {
        this.connectionManager.clearProxy();
    }

    public Svr3 svr3() {
        return this.svr3;
    }

    public CompletableFuture<CdsiLookupResponse> cdsiLookup(String username, String password, CdsiLookupRequest request, Consumer<byte[]> tokenConsumer) throws IOException, InterruptedException, ExecutionException {
        return CdsiLookup.start(this, username, password, request).thenCompose(lookup -> {
            tokenConsumer.accept(lookup.getToken());
            return lookup.complete();
        });
    }

    public static void checkClassesCanBeLoadedAsyncForTest() {
        String[] classesToLoad = new String[]{"org.signal.libsignal.net.CdsiLookupResponse$Entry", "org.signal.libsignal.net.NetworkException", "org.signal.libsignal.net.ChatServiceException", "org.signal.libsignal.protocol.ServiceId"};
        TokioAsyncContext context = new TokioAsyncContext();
        for (String className : classesToLoad) {
            try {
                context.loadClassAsync(className).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    TokioAsyncContext getAsyncContext() {
        return this.tokioAsyncContext;
    }

    ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ChatService createChatService(String username, String password) {
        return new ChatService(this.tokioAsyncContext, this.connectionManager, username, password);
    }

    static class ConnectionManager
    extends NativeHandleGuard.SimpleOwner {
        private ConnectionManager(Environment env, String userAgent) {
            super(Native.ConnectionManager_new(env.value, userAgent));
        }

        private void setProxy(String host, int port) throws IOException {
            FilterExceptions.filterExceptions(IOException.class, () -> this.guardedRunChecked(h -> Native.ConnectionManager_set_proxy(h, host, port)));
        }

        private void clearProxy() {
            this.guardedRun(Native::ConnectionManager_clear_proxy);
        }

        @Override
        protected void release(long nativeHandle) {
            Native.ConnectionManager_Destroy(nativeHandle);
        }
    }

    public static enum Environment {
        STAGING(0),
        PRODUCTION(1);

        private final int value;

        private Environment(int value) {
            this.value = value;
        }
    }
}

