/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.net.EnclaveAuth;
import org.signal.libsignal.net.Network;

public final class Svr3 {
    private Network network;

    Svr3(Network network) {
        this.network = network;
    }

    public final CompletableFuture<byte[]> backup(byte[] what, String password, int maxTries, EnclaveAuth auth) {
        try (NativeHandleGuard asyncRuntime = new NativeHandleGuard(this.network.getAsyncContext());){
            NativeHandleGuard connectionManager = new NativeHandleGuard(this.network.getConnectionManager());
            try {
                CompletableFuture<byte[]> completableFuture = Native.Svr3Backup(asyncRuntime.nativeHandle(), connectionManager.nativeHandle(), what, password, maxTries, auth.username, auth.password);
                connectionManager.close();
                return completableFuture;
            }
            catch (Throwable throwable) {
                try {
                    connectionManager.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public final CompletableFuture<RestoredSecret> restore(String password, byte[] shareSet, EnclaveAuth auth) {
        try (NativeHandleGuard asyncRuntime = new NativeHandleGuard(this.network.getAsyncContext());){
            NativeHandleGuard connectionManager = new NativeHandleGuard(this.network.getConnectionManager());
            try {
                CompletableFuture<RestoredSecret> completableFuture = Native.Svr3Restore(asyncRuntime.nativeHandle(), connectionManager.nativeHandle(), password, shareSet, auth.username, auth.password).thenApply(RestoredSecret::deserialize);
                connectionManager.close();
                return completableFuture;
            }
            catch (Throwable throwable) {
                try {
                    connectionManager.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public final CompletableFuture<Void> remove(EnclaveAuth auth) {
        try (NativeHandleGuard asyncRuntime = new NativeHandleGuard(this.network.getAsyncContext());){
            NativeHandleGuard connectionManager = new NativeHandleGuard(this.network.getConnectionManager());
            try {
                CompletableFuture<Void> completableFuture = Native.Svr3Remove(asyncRuntime.nativeHandle(), connectionManager.nativeHandle(), auth.username, auth.password);
                connectionManager.close();
                return completableFuture;
            }
            catch (Throwable throwable) {
                try {
                    connectionManager.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public record RestoredSecret(int triesRemaining, byte[] value) {
        static RestoredSecret deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.BIG_ENDIAN);
            int triesRemaining = buffer.getInt();
            byte[] value = new byte[32];
            buffer.get(value);
            return new RestoredSecret(triesRemaining, value);
        }
    }
}

