/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.net.ChatListener;
import org.signal.libsignal.net.ChatService;
import org.signal.libsignal.net.KeyTransparencyClient;
import org.signal.libsignal.net.Network;
import org.signal.libsignal.net.TokioAsyncContext;
import org.signal.libsignal.net.internal.BridgeChatListener;

public class UnauthenticatedChatService
extends ChatService {
    final Network.Environment environment;
    private final KeyTransparencyClient keyTransparencyClient;

    UnauthenticatedChatService(TokioAsyncContext tokioAsyncContext, Network.ConnectionManager connectionManager, ChatListener listener) {
        super(tokioAsyncContext, connectionManager, Native::ChatService_new_unauth, listener);
        this.environment = connectionManager.environment();
        this.keyTransparencyClient = new KeyTransparencyClient(this, tokioAsyncContext);
    }

    public KeyTransparencyClient keyTransparencyClient() {
        return this.keyTransparencyClient;
    }

    @Override
    protected CompletableFuture disconnectWrapper(long nativeAsyncContextHandle, long nativeChatServiceHandle) {
        return Native.ChatService_disconnect_unauth(nativeAsyncContextHandle, nativeChatServiceHandle);
    }

    @Override
    protected CompletableFuture<Object> sendWrapper(long nativeAsyncContextHandle, long nativeChatServiceHandle, long nativeRequestHandle, int timeoutMillis) {
        return Native.ChatService_unauth_send(nativeAsyncContextHandle, nativeChatServiceHandle, nativeRequestHandle, timeoutMillis);
    }

    @Override
    protected CompletableFuture<Object> connectWrapper(long nativeAsyncContextHandle, long nativeChatServiceHandle) {
        return Native.ChatService_connect_unauth(nativeAsyncContextHandle, nativeChatServiceHandle);
    }

    @Override
    protected CompletableFuture<Object> sendAndDebugWrapper(long nativeAsyncContextHandle, long nativeChatServiceHandle, long nativeRequestHandle, int timeoutMillis) {
        return Native.ChatService_unauth_send_and_debug(nativeAsyncContextHandle, nativeChatServiceHandle, nativeRequestHandle, timeoutMillis);
    }

    @Override
    protected void release(long nativeChatServiceHandle) {
        Native.UnauthChat_Destroy(nativeChatServiceHandle);
    }

    @Override
    protected void setListenerWrapper(long nativeAsyncContextHandle, long nativeChatServiceHandle, BridgeChatListener bridgeChatListener) {
        Native.ChatService_SetListenerUnauth(nativeAsyncContextHandle, nativeChatServiceHandle, bridgeChatListener);
    }
}

