/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.messagebackup;

import java.io.IOException;
import java.io.InputStream;
import org.signal.libsignal.internal.CalledFromNative;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.internal.NativeTesting;
import org.signal.libsignal.messagebackup.MessageBackup;
import org.signal.libsignal.messagebackup.ValidationError;

public class ComparableBackup
implements NativeHandleGuard.Owner {
    private final long unsafeHandle;

    public static ComparableBackup readUnencrypted(MessageBackup.Purpose purpose, InputStream input, long streamLength) throws ValidationError, IOException {
        long handle = FilterExceptions.filterExceptions(IOException.class, ValidationError.class, () -> NativeTesting.ComparableBackup_ReadUnencrypted(input, streamLength, purpose.ordinal()));
        return new ComparableBackup(handle);
    }

    public String getComparableString() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            String string = FilterExceptions.filterExceptions(() -> NativeTesting.ComparableBackup_GetComparableString(guard.nativeHandle()));
            return string;
        }
    }

    public String[] getUnknownFieldMessages() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            String[] stringArray = (String[])FilterExceptions.filterExceptions(() -> NativeTesting.ComparableBackup_GetUnknownFields(guard.nativeHandle()));
            return stringArray;
        }
    }

    @CalledFromNative
    private ComparableBackup(long unsafeHandle) {
        this.unsafeHandle = unsafeHandle;
    }

    protected void finalize() {
        NativeTesting.ComparableBackup_Destroy(this.unsafeHandle);
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }
}

