/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.messagebackup;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.messagebackup.BackupKey;
import org.signal.libsignal.protocol.ServiceId;

public class MessageBackupKey
implements NativeHandleGuard.Owner {
    private long nativeHandle;

    private MessageBackupKey(long nativeHandle) {
        this.nativeHandle = nativeHandle;
    }

    @Deprecated
    public MessageBackupKey(byte[] masterKey, ServiceId.Aci aci) {
        this.nativeHandle = Native.MessageBackupKey_FromMasterKey(masterKey, aci.toServiceIdFixedWidthBinary());
    }

    public MessageBackupKey(String accountEntropy, ServiceId.Aci aci) {
        this.nativeHandle = Native.MessageBackupKey_FromAccountEntropyPool(accountEntropy, aci.toServiceIdFixedWidthBinary());
    }

    public MessageBackupKey(BackupKey backupKey, byte[] backupId) {
        this.nativeHandle = Native.MessageBackupKey_FromBackupKeyAndBackupId(backupKey.getInternalContentsForJNI(), backupId);
    }

    @Deprecated
    public MessageBackupKey(byte[] backupKey, byte[] backupId) {
        this(FilterExceptions.filterExceptions(() -> new BackupKey(backupKey)), backupId);
    }

    public static MessageBackupKey fromParts(byte[] hmacKey, byte[] aesKey) {
        return new MessageBackupKey(Native.MessageBackupKey_FromParts(hmacKey, aesKey));
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.nativeHandle;
    }

    protected void finalize() {
        Native.MessageBackupKey_Destroy(this.nativeHandle);
    }

    public byte[] getHmacKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.MessageBackupKey_GetHmacKey(guard.nativeHandle());
            return byArray;
        }
    }

    public byte[] getAesKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.MessageBackupKey_GetAesKey(guard.nativeHandle());
            return byArray;
        }
    }
}

