/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class Hex {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toString(byte[] bytes) {
        return Hex.toString(bytes, 0, bytes.length);
    }

    public static String toString(byte[] bytes, int offset, int length) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            Hex.appendHexCharWithPrefix(buf, bytes[offset + i]);
            buf.append(", ");
        }
        return buf.toString();
    }

    public static String toStringCondensed(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            Hex.appendHexChar(buf, bytes[i]);
        }
        return buf.toString();
    }

    public static byte[] fromStringCondensed(String encoded) throws IOException {
        char[] data = encoded.toCharArray();
        int len = data.length;
        if ((len & 1) != 0) {
            throw new IOException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Character.digit(data[j], 16) << 4;
            f |= Character.digit(data[++j], 16);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static byte[] fromStringCondensedAssert(String encoded) {
        try {
            return Hex.fromStringCondensed(encoded);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static byte[] fromStringsCondensedAssert(String ... encoded) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            for (String next : encoded) {
                outputStream.write(Hex.fromStringCondensed(next));
            }
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void appendHexCharWithPrefix(StringBuffer buf, int b) {
        buf.append("(byte)0x");
        Hex.appendHexChar(buf, b);
    }

    private static void appendHexChar(StringBuffer buf, int b) {
        buf.append(HEX_DIGITS[b >> 4 & 0xF]);
        buf.append(HEX_DIGITS[b & 0xF]);
    }
}

