/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import java.lang.ref.WeakReference;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.internal.NativeTesting;
import org.signal.libsignal.net.ChatConnection;
import org.signal.libsignal.net.ChatConnectionListener;
import org.signal.libsignal.net.Network;
import org.signal.libsignal.net.TokioAsyncContext;
import org.signal.libsignal.net.internal.BridgeChatListener;
import org.signal.libsignal.protocol.util.Pair;

public class AuthenticatedChatConnection
extends ChatConnection {
    private AuthenticatedChatConnection(TokioAsyncContext tokioAsyncContext, long nativeHandle, ChatConnectionListener listener) {
        super(tokioAsyncContext, nativeHandle, listener);
    }

    static CompletableFuture<AuthenticatedChatConnection> connect(TokioAsyncContext tokioAsyncContext, Network.ConnectionManager connectionManager, String username, String password, boolean receiveStories, ChatConnectionListener chatListener) {
        return tokioAsyncContext.guardedMap(asyncContextHandle -> connectionManager.guardedMap(connectionManagerHandle -> Native.AuthenticatedChatConnection_connect(asyncContextHandle, connectionManagerHandle, username, password, receiveStories).thenApply(nativeHandle -> new AuthenticatedChatConnection(tokioAsyncContext, (long)nativeHandle, chatListener))));
    }

    public static Pair<AuthenticatedChatConnection, FakeChatRemote> fakeConnect(TokioAsyncContext tokioAsyncContext, ChatConnectionListener listener) {
        return AuthenticatedChatConnection.fakeConnect(tokioAsyncContext, listener, new String[0]);
    }

    public static Pair<AuthenticatedChatConnection, FakeChatRemote> fakeConnect(TokioAsyncContext tokioAsyncContext, ChatConnectionListener listener, String[] alerts) {
        return tokioAsyncContext.guardedMap(asyncContextHandle -> {
            SetChatLaterListenerBridge bridgeListener = new SetChatLaterListenerBridge();
            long fakeChatConnection = NativeTesting.TESTING_FakeChatConnection_Create(asyncContextHandle, bridgeListener, String.join((CharSequence)"\n", alerts));
            AuthenticatedChatConnection chat = new AuthenticatedChatConnection(tokioAsyncContext, NativeTesting.TESTING_FakeChatConnection_TakeAuthenticatedChat(fakeChatConnection), listener);
            bridgeListener.setChat(chat);
            FakeChatRemote fakeRemote = new FakeChatRemote(tokioAsyncContext, NativeTesting.TESTING_FakeChatConnection_TakeRemote(fakeChatConnection));
            NativeTesting.FakeChatConnection_Destroy(fakeChatConnection);
            return new Pair<AuthenticatedChatConnection, FakeChatRemote>(chat, fakeRemote);
        });
    }

    @Override
    protected CompletableFuture disconnectWrapper(long nativeAsyncContextHandle, long nativeChatConnectionHandle) {
        return Native.AuthenticatedChatConnection_disconnect(nativeAsyncContextHandle, nativeChatConnectionHandle);
    }

    @Override
    protected void startWrapper(long nativeChatConnectionHandle, BridgeChatListener listener) {
        Native.AuthenticatedChatConnection_init_listener(nativeChatConnectionHandle, listener);
    }

    @Override
    protected CompletableFuture<Object> sendWrapper(long nativeAsyncContextHandle, long nativeChatConnectionHandle, long nativeRequestHandle, int timeoutMillis) {
        return Native.AuthenticatedChatConnection_send(nativeAsyncContextHandle, nativeChatConnectionHandle, nativeRequestHandle, timeoutMillis);
    }

    @Override
    protected void release(long nativeChatConnectionHandle) {
        Native.AuthenticatedChatConnection_Destroy(nativeChatConnectionHandle);
    }

    private static final class SetChatLaterListenerBridge
    extends ChatConnection.ListenerBridge {
        String[] savedAlerts;

        SetChatLaterListenerBridge() {
            super(null);
        }

        void setChat(ChatConnection chat) {
            this.chat = new WeakReference<ChatConnection>(chat);
            if (this.savedAlerts != null) {
                super.onReceivedAlerts(this.savedAlerts);
                this.savedAlerts = null;
            }
        }

        @Override
        public void onReceivedAlerts(String[] alerts) {
            if (this.chat.get() == null) {
                this.savedAlerts = alerts;
                return;
            }
            super.onReceivedAlerts(alerts);
        }
    }

    static class FakeChatRemote
    extends NativeHandleGuard.SimpleOwner {
        private TokioAsyncContext tokioContext;

        private FakeChatRemote(TokioAsyncContext tokioContext, long nativeHandle) {
            super(nativeHandle);
            this.tokioContext = tokioContext;
        }

        public CompletableFuture<Pair<ChatConnection.InternalRequest, Long>> getNextIncomingRequest() {
            return this.tokioContext.guardedMap(asyncContextHandle -> this.guardedMap(fakeRemote -> NativeTesting.TESTING_FakeChatRemoteEnd_ReceiveIncomingRequest(asyncContextHandle, fakeRemote))).thenApply(sentRequest -> {
                try {
                    ChatConnection.InternalRequest httpRequest = new ChatConnection.InternalRequest(NativeTesting.TESTING_FakeChatSentRequest_TakeHttpRequest(sentRequest));
                    long requestId = NativeTesting.TESTING_FakeChatSentRequest_RequestId(sentRequest);
                    Pair<ChatConnection.InternalRequest, Long> pair = new Pair<ChatConnection.InternalRequest, Long>(httpRequest, requestId);
                    return pair;
                }
                finally {
                    NativeTesting.FakeChatSentRequest_Destroy(sentRequest);
                }
            });
        }

        @Override
        protected void release(long nativeHandle) {
            NativeTesting.FakeChatRemoteEnd_Destroy(nativeHandle);
        }
    }
}

