/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.metadata.certificate;

import java.util.Optional;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.metadata.certificate.ServerCertificate;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

public class SenderCertificate
extends NativeHandleGuard.SimpleOwner {
    @Override
    protected void release(long nativeHandle) {
        Native.SenderCertificate_Destroy(nativeHandle);
    }

    public SenderCertificate(byte[] serialized) throws InvalidCertificateException {
        super(SenderCertificate.createNativeFrom(serialized));
    }

    private static long createNativeFrom(byte[] serialized) throws InvalidCertificateException {
        try {
            return Native.SenderCertificate_Deserialize(serialized);
        }
        catch (Exception e) {
            throw new InvalidCertificateException(e);
        }
    }

    public SenderCertificate(long nativeHandle) {
        super(nativeHandle);
    }

    public ServerCertificate getSigner() {
        return new ServerCertificate(FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SenderCertificate_GetServerCertificate)));
    }

    public ECPublicKey getKey() {
        return new ECPublicKey(FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SenderCertificate_GetKey)));
    }

    public int getSenderDeviceId() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SenderCertificate_GetDeviceId));
    }

    public String getSenderUuid() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SenderCertificate_GetSenderUuid));
    }

    public Optional<String> getSenderE164() {
        return Optional.ofNullable(FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SenderCertificate_GetSenderE164)));
    }

    public String getSender() {
        return this.getSenderUuid();
    }

    public ServiceId.Aci getSenderAci() {
        try {
            return ServiceId.Aci.parseFromString(this.getSender());
        }
        catch (ServiceId.InvalidServiceIdException e) {
            return null;
        }
    }

    public long getExpiration() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SenderCertificate_GetExpiration));
    }

    public byte[] getSerialized() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SenderCertificate_GetSerialized));
    }

    public byte[] getCertificate() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SenderCertificate_GetCertificate));
    }

    public byte[] getSignature() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SenderCertificate_GetSignature));
    }
}

