/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.ecc;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

public class ECPrivateKey
extends NativeHandleGuard.SimpleOwner {
    static ECPrivateKey generate() {
        return new ECPrivateKey(Native.ECPrivateKey_Generate());
    }

    public ECPrivateKey(byte[] privateKey) throws InvalidKeyException {
        super(FilterExceptions.filterExceptions(InvalidKeyException.class, () -> Native.ECPrivateKey_Deserialize(privateKey)));
    }

    public ECPrivateKey(long nativeHandle) {
        super(ECPrivateKey.throwIfNull(nativeHandle));
    }

    private static long throwIfNull(long nativeHandle) {
        if (nativeHandle == 0L) {
            throw new NullPointerException();
        }
        return nativeHandle;
    }

    @Override
    protected void release(long nativeHandle) {
        Native.ECPrivateKey_Destroy(nativeHandle);
    }

    public byte[] serialize() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::ECPrivateKey_Serialize));
    }

    public byte[] calculateSignature(byte[] message) {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(nativeHandle -> Native.ECPrivateKey_Sign(nativeHandle, message)));
    }

    public byte[] calculateAgreement(ECPublicKey other) {
        try (NativeHandleGuard privateKey = new NativeHandleGuard(this);){
            NativeHandleGuard publicKey = new NativeHandleGuard(other);
            try {
                byte[] byArray = FilterExceptions.filterExceptions(() -> Native.ECPrivateKey_Agree(privateKey.nativeHandle(), publicKey.nativeHandle()));
                publicKey.close();
                return byArray;
            }
            catch (Throwable throwable) {
                try {
                    publicKey.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public ECPublicKey publicKey() {
        return new ECPublicKey(FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::ECPrivateKey_GetPublicKey)));
    }
}

