/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import java.util.Locale;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.internal.NativeTesting;
import org.signal.libsignal.net.FakeChatServer;
import org.signal.libsignal.net.Network;
import org.signal.libsignal.net.RegistrationSessionState;
import org.signal.libsignal.net.TokioAsyncContext;
import org.signal.libsignal.protocol.util.Pair;

public class RegistrationService
extends NativeHandleGuard.SimpleOwner {
    private TokioAsyncContext tokioAsyncContext;

    public static CompletableFuture<RegistrationService> createSession(Network network, CreateSession createSession) {
        TokioAsyncContext tokioAsyncContext = network.getAsyncContext();
        return tokioAsyncContext.guardedMap(asyncContext -> Native.RegistrationService_CreateSession(asyncContext, createSession, network.getConnectionManager())).thenApply(nativeHandle -> new RegistrationService((long)nativeHandle, tokioAsyncContext));
    }

    public static CompletableFuture<RegistrationService> resumeSession(Network network, String sessionId, String number) {
        TokioAsyncContext tokioAsyncContext = network.getAsyncContext();
        return tokioAsyncContext.guardedMap(asyncContext -> Native.RegistrationService_ResumeSession(asyncContext, sessionId, number, network.getConnectionManager())).thenApply(nativeHandle -> new RegistrationService((long)nativeHandle, tokioAsyncContext));
    }

    public CompletableFuture<Void> requestPushChallenge(String fcmPushToken) {
        return this.guardedMap(nativeHandle -> this.tokioAsyncContext.guardedMap(asyncContextHandle -> Native.RegistrationService_RequestPushChallenge(asyncContextHandle, nativeHandle, fcmPushToken, null)));
    }

    public CompletableFuture<Void> submitPushChallenge(String pushChallenge) {
        return this.guardedMap(nativeHandle -> this.tokioAsyncContext.guardedMap(asyncContextHandle -> Native.RegistrationService_SubmitPushChallenge(asyncContextHandle, nativeHandle, pushChallenge)));
    }

    public CompletableFuture<Void> requestVerificationCode(VerificationTransport transport, String client, Locale locale) {
        String[] stringArray;
        if (locale == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = locale.getLanguage() + "-" + locale.getCountry();
        }
        String[] languages = stringArray;
        return this.guardedMap(nativeHandle -> this.tokioAsyncContext.guardedMap(asyncContextHandle -> Native.RegistrationService_RequestVerificationCode(asyncContextHandle, nativeHandle, transport.name().toLowerCase(), client, languages)));
    }

    public CompletableFuture<Void> submitVerificationCode(String code) {
        return this.guardedMap(nativeHandle -> this.tokioAsyncContext.guardedMap(asyncContextHandle -> Native.RegistrationService_SubmitVerificationCode(asyncContextHandle, nativeHandle, code)));
    }

    public CompletableFuture<Void> submitCaptcha(String captchaValue) {
        return this.guardedMap(nativeHandle -> this.tokioAsyncContext.guardedMap(asyncContextHandle -> Native.RegistrationService_SubmitCaptcha(asyncContextHandle, nativeHandle, captchaValue)));
    }

    public String getSessionId() {
        return this.guardedMap(Native::RegistrationService_SessionId);
    }

    public RegistrationSessionState getSessionState() {
        return this.guardedMap(nativeHandle -> new RegistrationSessionState(Native.RegistrationService_RegistrationSession(nativeHandle)));
    }

    static Pair<FakeChatServer, CompletableFuture<RegistrationService>> fakeCreateSession(TokioAsyncContext asyncContext, CreateSession createSession) {
        FakeChatServer fakeServer = new FakeChatServer(asyncContext);
        CompletableFuture<RegistrationService> createSessionFut = asyncContext.guardedMap(tokioContext -> fakeServer.guardedMap(fakeChat -> NativeTesting.TESTING_FakeRegistrationSession_CreateSession(tokioContext, createSession, fakeChat))).thenApply(registration -> new RegistrationService((long)registration, asyncContext));
        return new Pair<FakeChatServer, CompletableFuture<RegistrationService>>(fakeServer, createSessionFut);
    }

    private RegistrationService(long nativeHandle, TokioAsyncContext tokioAsyncContext) {
        super(nativeHandle);
        this.tokioAsyncContext = tokioAsyncContext;
    }

    @Override
    protected void release(long nativeHandle) {
        Native.RegistrationService_Destroy(nativeHandle);
    }

    public record CreateSession(String number, String fcmPushToken, String mcc, String mnc) {
    }

    public static enum VerificationTransport {
        SMS,
        VOICE;

    }
}

