/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.kem;

import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.kem.KEMKeyType;
import org.signal.libsignal.protocol.kem.KEMPublicKey;
import org.signal.libsignal.protocol.kem.KEMSecretKey;

public class KEMKeyPair
extends NativeHandleGuard.SimpleOwner {
    public static KEMKeyPair generate(KEMKeyType reserved) {
        return new KEMKeyPair(Native.KyberKeyPair_Generate());
    }

    public KEMKeyPair(long nativeHandle) {
        super(KEMKeyPair.throwIfNull(nativeHandle));
    }

    private static long throwIfNull(long handle) {
        if (handle == 0L) {
            throw new NullPointerException();
        }
        return handle;
    }

    @Override
    protected void release(long nativeHandle) {
        Native.KyberKeyPair_Destroy(nativeHandle);
    }

    public KEMPublicKey getPublicKey() {
        return new KEMPublicKey(this.guardedMap(Native::KyberKeyPair_GetPublicKey));
    }

    public KEMSecretKey getSecretKey() {
        return new KEMSecretKey(this.guardedMap(Native::KyberKeyPair_GetSecretKey));
    }
}

