/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.kem;

import java.util.Arrays;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidKeyException;

public class KEMPublicKey
extends NativeHandleGuard.SimpleOwner {
    public KEMPublicKey(byte[] serialized, int offset) throws InvalidKeyException {
        super(FilterExceptions.filterExceptions(InvalidKeyException.class, () -> Native.KyberPublicKey_DeserializeWithOffset(serialized, offset)));
    }

    public KEMPublicKey(byte[] serialized) throws InvalidKeyException {
        super(FilterExceptions.filterExceptions(InvalidKeyException.class, () -> Native.KyberPublicKey_DeserializeWithOffset(serialized, 0)));
    }

    public KEMPublicKey(long nativeHandle) {
        super(KEMPublicKey.throwIfNull(nativeHandle));
    }

    private static long throwIfNull(long handle) {
        if (handle == 0L) {
            throw new NullPointerException();
        }
        return handle;
    }

    @Override
    protected void release(long nativeHandle) {
        Native.KyberPublicKey_Destroy(nativeHandle);
    }

    public byte[] serialize() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::KyberPublicKey_Serialize));
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof KEMPublicKey)) {
            return false;
        }
        return this.guardedMap(thisNativeHandle -> ((KEMPublicKey)other).guardedMap(otherNativeHandle -> Native.KyberPublicKey_Equals(thisNativeHandle, otherNativeHandle)));
    }

    public int hashCode() {
        return Arrays.hashCode(this.serialize());
    }
}

