/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.hsmenclave;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.signal.libsignal.hsmenclave.EnclaveCommunicationFailureException;
import org.signal.libsignal.hsmenclave.TrustedCodeMismatchException;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;

public class HsmEnclaveClient
extends NativeHandleGuard.SimpleOwner {
    public HsmEnclaveClient(byte[] public_key, List<byte[]> code_hashes) {
        super(HsmEnclaveClient.createNativeFrom(public_key, code_hashes));
    }

    private static long createNativeFrom(byte[] public_key, List<byte[]> code_hashes) {
        ByteArrayOutputStream concatHashes = new ByteArrayOutputStream();
        for (byte[] hash : code_hashes) {
            if (hash.length != 32) {
                throw new IllegalArgumentException("code hash length must be 32");
            }
            try {
                concatHashes.write(hash);
            }
            catch (IOException e) {
                throw new AssertionError("writing to ByteArrayOutputStream failed", e);
            }
        }
        return FilterExceptions.filterExceptions(() -> Native.HsmEnclaveClient_New(public_key, concatHashes.toByteArray()));
    }

    @Override
    protected void release(long nativeHandle) {
        Native.HsmEnclaveClient_Destroy(nativeHandle);
    }

    public byte[] initialRequest() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::HsmEnclaveClient_InitialRequest));
    }

    public void completeHandshake(byte[] handshakeResponse) throws EnclaveCommunicationFailureException, TrustedCodeMismatchException {
        FilterExceptions.filterExceptions(EnclaveCommunicationFailureException.class, TrustedCodeMismatchException.class, () -> this.guardedRunChecked(nativeHandle -> Native.HsmEnclaveClient_CompleteHandshake(nativeHandle, handshakeResponse)));
    }

    public byte[] establishedSend(byte[] plaintextToSend) throws EnclaveCommunicationFailureException {
        return FilterExceptions.filterExceptions(EnclaveCommunicationFailureException.class, () -> this.guardedMapChecked(nativeHandle -> Native.HsmEnclaveClient_EstablishedSend(nativeHandle, plaintextToSend)));
    }

    public byte[] establishedRecv(byte[] receivedCiphertext) throws EnclaveCommunicationFailureException {
        return FilterExceptions.filterExceptions(EnclaveCommunicationFailureException.class, () -> this.guardedMapChecked(nativeHandle -> Native.HsmEnclaveClient_EstablishedRecv(nativeHandle, receivedCiphertext)));
    }
}

