/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.internal;

import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;

public class NativeHandleGuard
implements AutoCloseable {
    private final Owner owner;

    public NativeHandleGuard(Owner owner) {
        this.owner = owner;
    }

    public long nativeHandle() {
        if (this.owner == null) {
            return 0L;
        }
        return this.owner.unsafeNativeHandleWithoutGuard();
    }

    @Override
    public void close() {
        Native.keepAlive(this.owner);
    }

    public static interface Owner {
        public long unsafeNativeHandleWithoutGuard();

        default public NativeHandleGuard guard() {
            return new NativeHandleGuard(this);
        }

        default public <T> T guardedMap(LongFunction<T> function) {
            try (NativeHandleGuard guard = new NativeHandleGuard(this);){
                T t = function.apply(guard.nativeHandle());
                return t;
            }
        }

        default public <T> T guardedMapChecked(FilterExceptions.ThrowingLongFunction<T> function) throws Exception {
            try (NativeHandleGuard guard = new NativeHandleGuard(this);){
                T t = function.apply(guard.nativeHandle());
                return t;
            }
        }

        default public void guardedRun(LongConsumer consumer) {
            try (NativeHandleGuard guard = new NativeHandleGuard(this);){
                consumer.accept(guard.nativeHandle());
            }
        }

        default public void guardedRunChecked(FilterExceptions.ThrowingLongConsumer consumer) throws Exception {
            try (NativeHandleGuard guard = new NativeHandleGuard(this);){
                consumer.accept(guard.nativeHandle());
            }
        }
    }

    public static abstract class CloseableOwner
    extends SimpleOwner
    implements AutoCloseable {
        private boolean isClosed = false;

        protected CloseableOwner(long nativeHandle) {
            super(nativeHandle);
        }

        @Override
        public void close() {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.release(this.unsafeNativeHandleWithoutGuard());
        }

        @Override
        protected void finalize() {
            this.close();
        }
    }

    public static abstract class SimpleOwner
    implements Owner {
        private final long nativeHandle;

        protected SimpleOwner(long nativeHandle) {
            this.nativeHandle = nativeHandle;
        }

        protected abstract void release(long var1);

        @Override
        public long unsafeNativeHandleWithoutGuard() {
            return this.nativeHandle;
        }

        protected void finalize() {
            this.release(this.nativeHandle);
        }
    }
}

