/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.state;

import java.time.Instant;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

public class SessionRecord
extends NativeHandleGuard.SimpleOwner {
    @Override
    protected void release(long nativeHandle) {
        Native.SessionRecord_Destroy(nativeHandle);
    }

    public SessionRecord() {
        super(Native.SessionRecord_NewFresh());
    }

    private SessionRecord(long nativeHandle) {
        super(nativeHandle);
    }

    public SessionRecord(byte[] serialized) throws InvalidMessageException {
        super(FilterExceptions.filterExceptions(InvalidMessageException.class, () -> Native.SessionRecord_Deserialize(serialized)));
    }

    public void archiveCurrentState() {
        FilterExceptions.filterExceptions(() -> this.guardedRunChecked(Native::SessionRecord_ArchiveCurrentState));
    }

    public int getSessionVersion() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SessionRecord_GetSessionVersion));
    }

    public int getRemoteRegistrationId() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SessionRecord_GetRemoteRegistrationId));
    }

    public int getLocalRegistrationId() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SessionRecord_GetLocalRegistrationId));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IdentityKey getRemoteIdentityKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] keyBytes = FilterExceptions.filterExceptions(InvalidKeyException.class, () -> Native.SessionRecord_GetRemoteIdentityKeyPublic(guard.nativeHandle()));
            if (keyBytes == null) {
                IdentityKey identityKey = null;
                return identityKey;
            }
            IdentityKey identityKey = new IdentityKey(keyBytes);
            return identityKey;
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
    }

    public IdentityKey getLocalIdentityKey() {
        NativeHandleGuard guard = new NativeHandleGuard(this);
        try {
            byte[] keyBytes = FilterExceptions.filterExceptions(InvalidKeyException.class, () -> Native.SessionRecord_GetLocalIdentityKeyPublic(guard.nativeHandle()));
            IdentityKey identityKey = new IdentityKey(keyBytes);
            guard.close();
            return identityKey;
        }
        catch (Throwable throwable) {
            try {
                try {
                    guard.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InvalidKeyException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public boolean hasSenderChain() {
        return this.hasSenderChain(Instant.now());
    }

    public boolean hasSenderChain(Instant now) {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(nativeHandle -> Native.SessionRecord_HasUsableSenderChain(nativeHandle, now.toEpochMilli())));
    }

    public boolean currentRatchetKeyMatches(ECPublicKey key) {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            NativeHandleGuard keyGuard = new NativeHandleGuard(key);
            try {
                boolean bl = FilterExceptions.filterExceptions(() -> Native.SessionRecord_CurrentRatchetKeyMatches(guard.nativeHandle(), keyGuard.nativeHandle()));
                keyGuard.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    keyGuard.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public byte[] serialize() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::SessionRecord_Serialize));
    }
}

