/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.metadata.certificate;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.metadata.certificate.ServerCertificate;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/signal/libsignal/metadata/certificate/CertificateValidator;", "", "trustRoot", "Lorg/signal/libsignal/protocol/ecc/ECPublicKey;", "<init>", "(Lorg/signal/libsignal/protocol/ecc/ECPublicKey;)V", "getTrustRoot", "()Lorg/signal/libsignal/protocol/ecc/ECPublicKey;", "validate", "", "certificate", "Lorg/signal/libsignal/metadata/certificate/SenderCertificate;", "validationTime", "", "Lorg/signal/libsignal/metadata/certificate/ServerCertificate;", "libsignal-client"})
public class CertificateValidator {
    @NotNull
    private final ECPublicKey trustRoot;

    public CertificateValidator(@NotNull ECPublicKey trustRoot) {
        Intrinsics.checkNotNullParameter((Object)trustRoot, (String)"trustRoot");
        this.trustRoot = trustRoot;
    }

    @NotNull
    public final ECPublicKey getTrustRoot() {
        return this.trustRoot;
    }

    public final void validate(@NotNull SenderCertificate certificate, long validationTime) throws InvalidCertificateException {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        try {
            certificate.guardedRun(arg_0 -> CertificateValidator.validate$lambda$1(this, validationTime, arg_0));
        }
        catch (Exception e) {
            throw new InvalidCertificateException(e);
        }
    }

    public final void validate(@NotNull ServerCertificate certificate) throws InvalidCertificateException {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        if (!this.trustRoot.verifySignature(certificate.getCertificate(), certificate.getSignature())) {
            throw new InvalidCertificateException("Signature failed");
        }
    }

    private static final void validate$lambda$1$lambda$0(long $certificateHandle, long $validationTime, long trustRootHandle) {
        if (!Native.SenderCertificate_Validate($certificateHandle, trustRootHandle, $validationTime)) {
            throw new InvalidCertificateException("Validation failed");
        }
    }

    private static final void validate$lambda$1(CertificateValidator this$0, long $validationTime, long certificateHandle) {
        this$0.trustRoot.guardedRun(arg_0 -> CertificateValidator.validate$lambda$1$lambda$0(certificateHandle, $validationTime, arg_0));
    }
}

