/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.groups;

import java.security.SecureRandom;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.signal.libsignal.zkgroup.groups.ProfileKeyCiphertext;
import org.signal.libsignal.zkgroup.groups.UuidCiphertext;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;

public class ClientZkGroupCipher {
    private final GroupSecretParams groupSecretParams;

    public ClientZkGroupCipher(GroupSecretParams groupSecretParams) {
        this.groupSecretParams = groupSecretParams;
    }

    public UuidCiphertext encrypt(ServiceId serviceId) {
        byte[] newContents = Native.GroupSecretParams_EncryptServiceId(this.groupSecretParams.getInternalContentsForJNI(), serviceId.toServiceIdFixedWidthBinary());
        try {
            return new UuidCiphertext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ServiceId decrypt(UuidCiphertext uuidCiphertext) throws VerificationFailedException {
        try {
            return ServiceId.parseFromFixedWidthBinary(FilterExceptions.filterExceptions(VerificationFailedException.class, () -> Native.GroupSecretParams_DecryptServiceId(this.groupSecretParams.getInternalContentsForJNI(), uuidCiphertext.getInternalContentsForJNI())));
        }
        catch (ServiceId.InvalidServiceIdException e) {
            throw new VerificationFailedException();
        }
    }

    public ProfileKeyCiphertext encryptProfileKey(ProfileKey profileKey, ServiceId.Aci userId) {
        byte[] newContents = Native.GroupSecretParams_EncryptProfileKey(this.groupSecretParams.getInternalContentsForJNI(), profileKey.getInternalContentsForJNI(), userId.toServiceIdFixedWidthBinary());
        try {
            return new ProfileKeyCiphertext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ProfileKey decryptProfileKey(ProfileKeyCiphertext profileKeyCiphertext, ServiceId.Aci userId) throws VerificationFailedException {
        byte[] newContents = FilterExceptions.filterExceptions(VerificationFailedException.class, () -> Native.GroupSecretParams_DecryptProfileKey(this.groupSecretParams.getInternalContentsForJNI(), profileKeyCiphertext.getInternalContentsForJNI(), userId.toServiceIdFixedWidthBinary()));
        try {
            return new ProfileKey(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public byte[] encryptBlob(byte[] plaintext) throws VerificationFailedException {
        return this.encryptBlob(new SecureRandom(), plaintext);
    }

    public byte[] encryptBlob(SecureRandom secureRandom, byte[] plaintext) throws VerificationFailedException {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        return Native.GroupSecretParams_EncryptBlobWithPaddingDeterministic(this.groupSecretParams.getInternalContentsForJNI(), random, plaintext, 0);
    }

    public byte[] decryptBlob(byte[] blobCiphertext) throws VerificationFailedException {
        return FilterExceptions.filterExceptions(VerificationFailedException.class, () -> Native.GroupSecretParams_DecryptBlobWithPadding(this.groupSecretParams.getInternalContentsForJNI(), blobCiphertext));
    }
}

