/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.InvalidVersionException;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.util.Pair;

public class SealedSenderMultiRecipientMessage {
    private final byte[] fullMessageData;
    private final Map<ServiceId, Recipient> recipients;
    private final List<ServiceId> excludedRecipients;
    private final int offsetOfSharedData;
    private static final byte SERIALIZED_RECIPIENT_VIEW_VERSION = 1;
    private static final byte[] ZERO_DEVICE_IDS = new byte[0];
    private static final short[] ZERO_REGISTRATION_IDS = new short[0];

    public static SealedSenderMultiRecipientMessage parse(byte[] input) throws InvalidMessageException, InvalidVersionException {
        return (SealedSenderMultiRecipientMessage)Native.SealedSender_MultiRecipientParseSentMessage(input);
    }

    private SealedSenderMultiRecipientMessage(byte[] fullMessageData, Map<ServiceId, Recipient> recipients, List<ServiceId> excludedRecipients, int offsetOfSharedData) {
        this.fullMessageData = fullMessageData;
        this.recipients = recipients;
        this.excludedRecipients = excludedRecipients;
        this.offsetOfSharedData = offsetOfSharedData;
    }

    public byte[] serialized() {
        return this.fullMessageData;
    }

    public Map<ServiceId, Recipient> getRecipients() {
        return this.recipients;
    }

    public List<ServiceId> getExcludedRecipients() {
        return this.excludedRecipients;
    }

    public byte[] messageForRecipient(Recipient recipient) {
        int lengthOfSharedData = this.fullMessageData.length - this.offsetOfSharedData;
        ByteBuffer bbuf = ByteBuffer.allocate(this.messageSizeForRecipient(recipient));
        bbuf.put((byte)34);
        bbuf.put(this.fullMessageData, recipient.offsetOfRecipientSpecificKeyMaterial, recipient.lengthOfRecipientSpecificKeyMaterial);
        bbuf.put(this.fullMessageData, this.offsetOfSharedData, lengthOfSharedData);
        return bbuf.array();
    }

    public int messageSizeForRecipient(Recipient recipient) {
        int lengthOfSharedData = this.fullMessageData.length - this.offsetOfSharedData;
        return 1 + recipient.lengthOfRecipientSpecificKeyMaterial + lengthOfSharedData;
    }

    public byte[] serializedRecipientView(Recipient recipient) {
        ByteBuffer bbuf = ByteBuffer.allocate(13);
        bbuf.put((byte)1);
        bbuf.putInt(this.offsetOfSharedData);
        bbuf.putInt(recipient.offsetOfRecipientSpecificKeyMaterial);
        bbuf.putInt(recipient.lengthOfRecipientSpecificKeyMaterial);
        assert (!bbuf.hasRemaining());
        return bbuf.array();
    }

    public static byte[] messageForRecipient(byte[] fullMessageData, byte[] serializedRecipientView) throws InvalidVersionException {
        if (serializedRecipientView.length != 13) {
            throw new IllegalArgumentException("Invalid length for serialized view: " + serializedRecipientView.length);
        }
        ByteBuffer wrapped = ByteBuffer.wrap(serializedRecipientView);
        byte version = wrapped.get();
        if (version != 1) {
            throw new InvalidVersionException("Recipient view version " + version + " is not supported");
        }
        int offsetOfSharedData = wrapped.getInt();
        int offsetOfRecipientSpecificKeyMaterial = wrapped.getInt();
        int lengthOfRecipientSpecificKeyMaterial = wrapped.getInt();
        assert (!wrapped.hasRemaining());
        Recipient recipient = new Recipient(ZERO_DEVICE_IDS, ZERO_REGISTRATION_IDS, offsetOfRecipientSpecificKeyMaterial, lengthOfRecipientSpecificKeyMaterial);
        SealedSenderMultiRecipientMessage message = new SealedSenderMultiRecipientMessage(fullMessageData, Collections.emptyMap(), Collections.emptyList(), offsetOfSharedData);
        return message.messageForRecipient(recipient);
    }

    public static class Recipient {
        private final byte[] devices;
        private final short[] registrationIds;
        private final int offsetOfRecipientSpecificKeyMaterial;
        private final int lengthOfRecipientSpecificKeyMaterial;

        private Recipient(byte[] devices, short[] registrationIds, int offsetOfRecipientSpecificKeyMaterial, int lengthOfRecipientSpecificKeyMaterial) {
            assert (devices.length == registrationIds.length);
            this.devices = devices;
            this.registrationIds = registrationIds;
            this.offsetOfRecipientSpecificKeyMaterial = offsetOfRecipientSpecificKeyMaterial;
            this.lengthOfRecipientSpecificKeyMaterial = lengthOfRecipientSpecificKeyMaterial;
        }

        public byte[] getDevices() {
            return this.devices;
        }

        public Stream<Pair<Byte, Short>> getDevicesAndRegistrationIds() {
            return IntStream.range(0, this.devices.length).mapToObj(i -> new Pair<Byte, Short>(this.devices[i], this.registrationIds[i]));
        }

        public boolean equals(Object other) {
            if (!(other instanceof Recipient)) {
                return false;
            }
            Recipient otherRecipient = (Recipient)other;
            return Arrays.equals(this.devices, otherRecipient.devices) && Arrays.equals(this.registrationIds, otherRecipient.registrationIds) && this.offsetOfRecipientSpecificKeyMaterial == otherRecipient.offsetOfRecipientSpecificKeyMaterial && this.lengthOfRecipientSpecificKeyMaterial == otherRecipient.lengthOfRecipientSpecificKeyMaterial;
        }

        public int hashCode() {
            return this.offsetOfRecipientSpecificKeyMaterial ^ Arrays.hashCode(this.devices) ^ Arrays.hashCode(this.registrationIds);
        }
    }
}

