/*
 * Decompiled with CFR 0.152.
 */
package org.signal.ringrtc;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.IOException;
import java.util.List;
import org.signal.ringrtc.CallConnectionFactory;
import org.signal.ringrtc.CallException;
import org.signal.ringrtc.CalledByNative;
import org.signal.ringrtc.Log;
import org.signal.ringrtc.SignalMessageRecipient;
import org.webrtc.IceCandidate;
import org.webrtc.MediaStream;
import org.webrtc.NativePeerConnectionFactory;
import org.webrtc.PeerConnection;
import org.whispersystems.signalservice.api.SignalServiceAccountManager;
import org.whispersystems.signalservice.api.crypto.UntrustedIdentityException;
import org.whispersystems.signalservice.api.messages.calls.IceUpdateMessage;
import org.whispersystems.signalservice.api.push.exceptions.UnregisteredUserException;

public class CallConnection
extends PeerConnection {
    private static final String TAG = CallConnection.class.getSimpleName();
    private long nativeCallConnection;
    @NonNull
    private final Context context;
    @NonNull
    private final Long callId;
    @NonNull
    private final SignalMessageRecipient recipient;

    CallConnection(NativeFactory factory) {
        super((NativePeerConnectionFactory)factory);
        this.nativeCallConnection = factory.nativeCallConnection;
        this.callId = factory.callId;
        this.recipient = factory.recipient;
        this.context = ((NativeFactory)factory).callConnectionFactory.context;
        Log.i(TAG, "create: callId: 0x" + Long.toHexString(this.callId));
    }

    static long createNativeCallConnectionObserver(Observer observer, Long callId, SignalMessageRecipient recipient) {
        return CallConnection.nativeCreateCallConnectionObserver(observer, callId, recipient);
    }

    private void checkCallConnectionExists() {
        if (this.nativeCallConnection == 0L) {
            throw new IllegalStateException("CallConnection has been disposed.");
        }
    }

    public void dispose() {
        this.checkCallConnectionExists();
        Log.i(TAG, "CallConnection.dispose(): closing native call connection");
        this.nativeClose(this.nativeCallConnection);
        Log.i(TAG, "CallConnection.dispose(): calling super.close()");
        super.close();
        Log.i(TAG, "CallConnection.dispose(): calling super.dispose()");
        super.dispose();
        Log.i(TAG, "CallConnection.dispose(): disposing native call connection");
        this.nativeDispose(this.nativeCallConnection);
        this.nativeCallConnection = 0L;
    }

    public void sendOffer() throws CallException {
        Log.i(TAG, "CallConnection::sendOffer():");
        this.checkCallConnectionExists();
        this.nativeSendOffer(this.nativeCallConnection);
    }

    public boolean validateResponse(SignalMessageRecipient recipient, @Nullable Long inCallId) throws CallException {
        Log.i(TAG, "CallConnection::validateResponse():");
        this.checkCallConnectionExists();
        return inCallId != null && inCallId.longValue() == this.callId.longValue() && this.recipient.isEqual(recipient) && this.nativeValidateResponseState(this.nativeCallConnection);
    }

    public void handleOfferAnswer(String sessionDescription) throws CallException {
        this.checkCallConnectionExists();
        this.nativeHandleOfferAnswer(this.nativeCallConnection, sessionDescription);
    }

    public void acceptOffer(String offer) throws CallException {
        this.checkCallConnectionExists();
        this.nativeAcceptOffer(this.nativeCallConnection, offer);
    }

    public void hangUp() throws CallException {
        this.checkCallConnectionExists();
        this.nativeHangUp(this.nativeCallConnection);
    }

    public void answerCall() throws CallException {
        this.checkCallConnectionExists();
        this.nativeAnswerCall(this.nativeCallConnection);
    }

    public boolean addIceCandidate(IceCandidate candidate) {
        boolean result;
        this.checkCallConnectionExists();
        try {
            result = this.nativeAddIceCandidate(this.nativeCallConnection, candidate.sdpMid, candidate.sdpMLineIndex, candidate.sdp);
        }
        catch (CallException e) {
            Log.w(TAG, "addIceCandidate() failed:", e);
            result = false;
        }
        return result;
    }

    public void sendVideoStatus(boolean enabled) throws CallException {
        this.checkCallConnectionExists();
        this.nativeSendVideoStatus(this.nativeCallConnection, enabled);
    }

    @Nullable
    @CalledByNative
    Exception sendSignalServiceOffer(SignalMessageRecipient recipient, long callId, String description) {
        Throwable exception = null;
        Log.i(TAG, "CallConnection::sendSignalServiceOffer(): callId: 0x" + Long.toHexString(callId));
        try {
            recipient.sendOfferMessage(this.context, callId, description);
        }
        catch (UnregisteredUserException e) {
            exception = e;
            Log.w(TAG, e);
        }
        catch (UntrustedIdentityException e) {
            exception = e;
            Log.w(TAG, e);
        }
        catch (IOException e) {
            exception = e;
            Log.w(TAG, e);
        }
        return exception;
    }

    @Nullable
    @CalledByNative
    Exception sendSignalServiceAnswer(SignalMessageRecipient recipient, long callId, String description) {
        Throwable exception = null;
        Log.i(TAG, "CallConnection::sendSignalServiceAnswer(): callId: 0x" + Long.toHexString(callId));
        try {
            recipient.sendAnswerMessage(this.context, callId, description);
        }
        catch (UnregisteredUserException e) {
            exception = e;
            Log.w(TAG, e);
        }
        catch (UntrustedIdentityException e) {
            exception = e;
            Log.w(TAG, e);
        }
        catch (IOException e) {
            exception = e;
            Log.w(TAG, e);
        }
        return exception;
    }

    @Nullable
    @CalledByNative
    Exception sendSignalServiceIceUpdates(SignalMessageRecipient recipient, List<IceUpdateMessage> iceUpdateMessages) {
        Throwable exception = null;
        Log.i(TAG, "CallConnection::sendSignalServiceIceUpdates(): iceUpdates: " + iceUpdateMessages.size());
        try {
            recipient.sendIceUpdates(this.context, iceUpdateMessages);
        }
        catch (UnregisteredUserException e) {
            exception = e;
            Log.w(TAG, e);
        }
        catch (UntrustedIdentityException e) {
            exception = e;
            Log.w(TAG, e);
        }
        catch (IOException e) {
            exception = e;
            Log.w(TAG, e);
        }
        return exception;
    }

    @CalledByNative
    void sendSignalServiceHangup(SignalMessageRecipient recipient, long callId) {
        Log.i(TAG, "CallConnection::sendSignalServiceHangup(): callId: 0x" + Long.toHexString(callId));
        try {
            recipient.sendHangupMessage(this.context, callId);
        }
        catch (Exception e) {
            Log.w(TAG, e);
        }
    }

    private static native long nativeCreateCallConnectionObserver(Observer var0, long var1, SignalMessageRecipient var3);

    private static native long nativeGetNativePeerConnection(long var0);

    private native void nativeClose(long var1);

    private native void nativeDispose(long var1);

    private native void nativeSendOffer(long var1) throws CallException;

    private native boolean nativeValidateResponseState(long var1) throws CallException;

    private native void nativeHandleOfferAnswer(long var1, String var3) throws CallException;

    private native void nativeAcceptOffer(long var1, String var3) throws CallException;

    private native void nativeHangUp(long var1) throws CallException;

    private native void nativeAnswerCall(long var1) throws CallException;

    private native void nativeSendVideoStatus(long var1, boolean var3) throws CallException;

    private native boolean nativeAddIceCandidate(long var1, String var3, int var4, String var5) throws CallException;

    static class NativeFactory
    implements NativePeerConnectionFactory {
        private long nativeCallConnection;
        private CallConnectionFactory callConnectionFactory;
        private Long callId;
        private SignalMessageRecipient recipient;

        protected NativeFactory(long nativeCallConnection, @NonNull CallConnectionFactory callConnectionFactory, @NonNull Long callId, @NonNull SignalMessageRecipient recipient) {
            this.nativeCallConnection = nativeCallConnection;
            this.callConnectionFactory = callConnectionFactory;
            this.callId = callId;
            this.recipient = recipient;
        }

        public long createNativePeerConnection() {
            Log.d(TAG, "Creating CallConnection() with createNativeCallConnection(): ");
            return CallConnection.nativeGetNativePeerConnection(this.nativeCallConnection);
        }
    }

    public static interface Observer {
        @CalledByNative
        public void onCallEvent(SignalMessageRecipient var1, long var2, CallEvent var4);

        @CalledByNative
        public void onCallError(SignalMessageRecipient var1, long var2, Exception var4);

        @CalledByNative
        public void onAddStream(SignalMessageRecipient var1, long var2, MediaStream var4);
    }

    public static enum CallError {
        UNREGISTERED_USER,
        UNTRUSTED_IDENTITY,
        NETWORK_FAILURE,
        INTERNAL_FAILURE,
        FAILURE;


        @CalledByNative
        public static CallError fromNativeIndex(int nativeIndex) {
            return CallError.values()[nativeIndex];
        }
    }

    public static enum CallEvent {
        RINGING,
        REMOTE_CONNECTED,
        REMOTE_VIDEO_ENABLE,
        REMOTE_VIDEO_DISABLE,
        REMOTE_HANGUP,
        CONNECTION_FAILED,
        CALL_TIMEOUT,
        CALL_RECONNECTING;


        @CalledByNative
        static CallEvent fromNativeIndex(int nativeIndex) {
            return CallEvent.values()[nativeIndex];
        }
    }

    public static class Configuration {
        private final String TAG = Configuration.class.getSimpleName();
        public final SignalServiceAccountManager accountManager;
        public final boolean hideIp;
        public final long callId;
        public final SignalMessageRecipient recipient;
        public final boolean outBound;

        public Configuration(Long callId, boolean outBound, SignalMessageRecipient recipient, SignalServiceAccountManager accountManager, boolean hideIp) {
            Log.i(this.TAG, "Created Configuration()");
            this.callId = callId;
            this.outBound = outBound;
            this.recipient = recipient;
            this.accountManager = accountManager;
            this.hideIp = hideIp;
        }
    }
}

