/*
 * Decompiled with CFR 0.152.
 */
package org.signal.ringrtc;

import org.signal.ringrtc.Log;
import org.webrtc.Loggable;
import org.webrtc.Logging;

public final class WebRtcLogger
implements Loggable {
    private static final String TAG = Log.class.getSimpleName();

    public void onLogMessage(String message, Logging.Severity severity, String tag) {
        switch (severity) {
            case LS_NONE: {
                break;
            }
            case LS_ERROR: {
                Log.e(tag, message);
                break;
            }
            case LS_WARNING: {
                Log.w(tag, message);
                break;
            }
            case LS_INFO: {
                Log.i(tag, message);
                break;
            }
            case LS_VERBOSE: {
                Log.d(tag, message);
                break;
            }
            default: {
                Log.w(TAG, "Unknown log level: " + tag + ", " + message);
            }
        }
    }
}

