/*
 * Decompiled with CFR 0.152.
 */
package org.signal.grpc.simple;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.html.HtmlEscapers;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.compiler.PluginProtos;
import com.salesforce.jprotoc.Generator;
import com.salesforce.jprotoc.GeneratorException;
import com.salesforce.jprotoc.ProtoTypeMap;
import com.salesforce.jprotoc.ProtocPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SimpleGrpcGenerator
extends Generator {
    private static final String CLASS_PREFIX = "Simple";
    private static final String SERVICE_JAVADOC_PREFIX = "    ";
    private static final String METHOD_JAVADOC_PREFIX = "        ";
    private static final int SERVICE_NUMBER_OF_PATHS = 2;
    private static final int METHOD_NUMBER_OF_PATHS = 4;

    public static void main(String ... args) {
        if (args.length == 0) {
            ProtocPlugin.generate((Generator)new SimpleGrpcGenerator());
        } else if (args.length == 1) {
            ProtocPlugin.debug((Generator)new SimpleGrpcGenerator(), (String)args[0]);
        } else {
            System.err.println("Usage: SimpleGrpcGenerator [DESCRIPTOR_DUMP_FILE]");
        }
    }

    public List<PluginProtos.CodeGeneratorResponse.File> generateFiles(PluginProtos.CodeGeneratorRequest request) throws GeneratorException {
        List<DescriptorProtos.FileDescriptorProto> protosToGenerate = request.getProtoFileList().stream().filter(protoFile -> request.getFileToGenerateList().contains((Object)protoFile.getName())).toList();
        return this.generateFiles(this.findServices(protosToGenerate, ProtoTypeMap.of((Collection)request.getProtoFileList())));
    }

    protected List<PluginProtos.CodeGeneratorResponse.Feature> supportedFeatures() {
        return List.of(PluginProtos.CodeGeneratorResponse.Feature.FEATURE_PROTO3_OPTIONAL);
    }

    private List<ServiceContext> findServices(List<DescriptorProtos.FileDescriptorProto> fileDescriptorProtos, ProtoTypeMap typeMap) {
        return fileDescriptorProtos.stream().flatMap(fileDescriptorProto -> IntStream.range(0, fileDescriptorProto.getServiceCount()).mapToObj(serviceNumber -> SimpleGrpcGenerator.buildServiceContext(fileDescriptorProto, typeMap, serviceNumber))).toList();
    }

    private static ServiceContext buildServiceContext(DescriptorProtos.FileDescriptorProto fileDescriptorProto, ProtoTypeMap typeMap, int serviceNumber) {
        DescriptorProtos.ServiceDescriptorProto serviceProto = fileDescriptorProto.getService(serviceNumber);
        List locations = fileDescriptorProto.getSourceCodeInfo().getLocationList();
        DescriptorProtos.SourceCodeInfo.Location serviceLocation = locations.stream().filter(location -> location.getPathCount() >= 2 && location.getPath(0) == 6 && location.getPath(1) == serviceNumber).filter(location -> location.getPathCount() == 2).findFirst().orElseGet(DescriptorProtos.SourceCodeInfo.Location::getDefaultInstance);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.fileName = CLASS_PREFIX + serviceProto.getName() + "Grpc.java";
        serviceContext.className = CLASS_PREFIX + serviceProto.getName() + "Grpc";
        serviceContext.serviceName = serviceProto.getName();
        serviceContext.deprecated = serviceProto.getOptions() != null && serviceProto.getOptions().getDeprecated();
        serviceContext.protoName = fileDescriptorProto.getName();
        serviceContext.packageName = SimpleGrpcGenerator.extractPackageName(fileDescriptorProto);
        serviceContext.javaDoc = SimpleGrpcGenerator.getJavaDoc(SimpleGrpcGenerator.getComments(serviceLocation), SERVICE_JAVADOC_PREFIX);
        for (int methodNumber = 0; methodNumber < serviceProto.getMethodCount(); ++methodNumber) {
            serviceContext.methods.add(SimpleGrpcGenerator.buildMethodContext(serviceProto.getMethod(methodNumber), typeMap, locations, methodNumber));
        }
        return serviceContext;
    }

    private static String extractPackageName(DescriptorProtos.FileDescriptorProto proto) {
        String javaPackage;
        DescriptorProtos.FileOptions options = proto.getOptions();
        if (options != null && !Strings.isNullOrEmpty((String)(javaPackage = options.getJavaPackage()))) {
            return javaPackage;
        }
        return Strings.nullToEmpty((String)proto.getPackage());
    }

    private static MethodContext buildMethodContext(DescriptorProtos.MethodDescriptorProto methodProto, ProtoTypeMap typeMap, List<DescriptorProtos.SourceCodeInfo.Location> locations, int methodNumber) {
        DescriptorProtos.SourceCodeInfo.Location methodLocation = locations.stream().filter(location -> location.getPathCount() == 4 && location.getPath(3) == methodNumber).findFirst().orElseGet(DescriptorProtos.SourceCodeInfo.Location::getDefaultInstance);
        MethodContext methodContext = new MethodContext();
        methodContext.methodName = SimpleGrpcGenerator.lowerCaseFirst(methodProto.getName());
        methodContext.inputType = typeMap.toJavaTypeName(methodProto.getInputType());
        methodContext.outputType = typeMap.toJavaTypeName(methodProto.getOutputType());
        methodContext.deprecated = methodProto.getOptions() != null && methodProto.getOptions().getDeprecated();
        methodContext.isManyInput = methodProto.getClientStreaming();
        methodContext.isManyOutput = methodProto.getServerStreaming();
        methodContext.methodNumber = methodNumber;
        methodContext.javaDoc = SimpleGrpcGenerator.getJavaDoc(SimpleGrpcGenerator.getComments(methodLocation), METHOD_JAVADOC_PREFIX);
        if (!methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
            methodContext.simpleCallsMethodName = "unaryCall";
            methodContext.grpcCallsMethodName = "asyncUnaryCall";
        }
        if (!methodProto.getClientStreaming() && methodProto.getServerStreaming()) {
            methodContext.simpleCallsMethodName = "serverStreamingCall";
            methodContext.grpcCallsMethodName = "asyncServerStreamingCall";
        }
        if (methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
            methodContext.simpleCallsMethodName = "clientStreamingCall";
            methodContext.grpcCallsMethodName = "asyncClientStreamingCall";
        }
        if (methodProto.getClientStreaming() && methodProto.getServerStreaming()) {
            methodContext.simpleCallsMethodName = "bidirectionalStreamingCall";
            methodContext.grpcCallsMethodName = "asyncBidiStreamingCall";
        }
        return methodContext;
    }

    private static String lowerCaseFirst(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    private List<PluginProtos.CodeGeneratorResponse.File> generateFiles(List<ServiceContext> services) {
        return services.stream().map(this::buildFile).collect(Collectors.toList());
    }

    private PluginProtos.CodeGeneratorResponse.File buildFile(ServiceContext serviceContext) {
        return PluginProtos.CodeGeneratorResponse.File.newBuilder().setName(SimpleGrpcGenerator.getGeneratedFilename(serviceContext)).setContent(this.applyTemplate("SimpleStub.mustache", serviceContext)).build();
    }

    @VisibleForTesting
    static String getGeneratedFilename(ServiceContext serviceContext) {
        String dir;
        String string = dir = serviceContext.packageName != null ? serviceContext.packageName.replace('.', '/') : null;
        if (Strings.isNullOrEmpty(dir)) {
            return serviceContext.fileName;
        }
        return dir + "/" + serviceContext.fileName;
    }

    private static String getComments(DescriptorProtos.SourceCodeInfo.Location location) {
        return location.getLeadingComments().isEmpty() ? location.getTrailingComments() : location.getLeadingComments();
    }

    private static String getJavaDoc(String comments, String prefix) {
        if (comments.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder("/**\n").append(prefix).append(" * <pre>\n");
        Arrays.stream(HtmlEscapers.htmlEscaper().escape(comments).split("\n")).map(line -> line.replace("*/", "&#42;&#47;").replace("*", "&#42;")).forEach(line -> builder.append(prefix).append(" * ").append((String)line).append("\n"));
        builder.append(prefix).append(" * </pre>\n").append(prefix).append(" */");
        return builder.toString();
    }

    @VisibleForTesting
    static class ServiceContext {
        public String fileName;
        public String protoName;
        public String packageName;
        public String className;
        public String serviceName;
        public boolean deprecated;
        public String javaDoc;
        public List<MethodContext> methods = new ArrayList<MethodContext>();

        ServiceContext() {
        }

        public List<MethodContext> unaryRequestMethods() {
            return this.methods.stream().filter(m -> !m.isManyInput).collect(Collectors.toList());
        }
    }

    @VisibleForTesting
    static class MethodContext {
        public String methodName;
        public String inputType;
        public String outputType;
        public boolean deprecated;
        public boolean isManyInput;
        public boolean isManyOutput;
        public String simpleCallsMethodName;
        public String grpcCallsMethodName;
        public int methodNumber;
        public String javaDoc;

        MethodContext() {
        }

        public String methodNameUpperUnderscore() {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.methodName.length(); ++i) {
                char c = this.methodName.charAt(i);
                s.append(Character.toUpperCase(c));
                if (i >= this.methodName.length() - 1 || !Character.isLowerCase(c) || !Character.isUpperCase(this.methodName.charAt(i + 1))) continue;
                s.append('_');
            }
            return s.toString();
        }

        public String methodNamePascalCase() {
            String mn = this.methodName.replace("_", "");
            return Character.toUpperCase(mn.charAt(0)) + mn.substring(1);
        }

        public String methodNameCamelCase() {
            String mn = this.methodName.replace("_", "");
            return Character.toLowerCase(mn.charAt(0)) + mn.substring(1);
        }
    }
}

