/*
 * Decompiled with CFR 0.152.
 */
package org.signal.zkgroup.internal;

import java.util.Arrays;
import java.util.Locale;
import org.signal.zkgroup.InvalidInputException;

public abstract class ByteArray {
    protected final byte[] contents;

    protected ByteArray(byte[] contents, int expectedLength) throws InvalidInputException {
        this.contents = ByteArray.cloneArrayOfLength(contents, expectedLength);
    }

    protected ByteArray(byte[] contents, int expectedLength, boolean unrecoverable) {
        try {
            this.contents = ByteArray.cloneArrayOfLength(contents, expectedLength);
        }
        catch (InvalidInputException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static byte[] cloneArrayOfLength(byte[] bytes, int expectedLength) throws InvalidInputException {
        if (bytes.length != expectedLength) {
            throw new InvalidInputException(String.format(Locale.US, "Length of array supplied was %d expected %d", bytes.length, expectedLength));
        }
        return (byte[])bytes.clone();
    }

    public byte[] getInternalContentsForJNI() {
        return this.contents;
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + Arrays.hashCode(this.contents);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArray other = (ByteArray)o;
        if (this.contents == other.contents) {
            return true;
        }
        if (this.contents.length != other.contents.length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < this.contents.length; ++i) {
            result |= this.contents[i] ^ other.contents[i];
        }
        return result == 0;
    }
}

