/*
 * Decompiled with CFR 0.152.
 */
package org.signal.zkgroup.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;

public final class Native {
    public static final int FFI_RETURN_OK = 0;
    public static final int FFI_RETURN_INTERNAL_ERROR = 1;
    public static final int FFI_RETURN_INPUT_ERROR = 2;
    public static final int RANDOM_LENGTH = 32;

    private Native() {
    }

    private static void copyToTempFileAndLoad(InputStream in, String extension) throws IOException {
        File tempFile = Files.createTempFile("resource", extension, new FileAttribute[0]).toFile();
        tempFile.deleteOnExit();
        try (FileOutputStream out = new FileOutputStream(tempFile);){
            Native.copy(in, out);
        }
        System.load(tempFile.getAbsolutePath());
    }

    public static native int profileKeyGetCommitmentJNI(byte[] var0, byte[] var1, byte[] var2);

    public static native int profileKeyGetProfileKeyVersionJNI(byte[] var0, byte[] var1, byte[] var2);

    public static native int profileKeyCommitmentCheckValidContentsJNI(byte[] var0);

    public static native int groupSecretParamsGenerateDeterministicJNI(byte[] var0, byte[] var1);

    public static native int groupSecretParamsDeriveFromMasterKeyJNI(byte[] var0, byte[] var1);

    public static native int groupSecretParamsGetMasterKeyJNI(byte[] var0, byte[] var1);

    public static native int groupSecretParamsGetPublicParamsJNI(byte[] var0, byte[] var1);

    public static native int groupSecretParamsCheckValidContentsJNI(byte[] var0);

    public static native int groupSecretParamsEncryptUuidJNI(byte[] var0, byte[] var1, byte[] var2);

    public static native int groupSecretParamsDecryptUuidJNI(byte[] var0, byte[] var1, byte[] var2);

    public static native int groupSecretParamsEncryptProfileKeyJNI(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    public static native int groupSecretParamsDecryptProfileKeyJNI(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    public static native int groupSecretParamsEncryptBlobDeterministicJNI(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    public static native int groupSecretParamsDecryptBlobJNI(byte[] var0, byte[] var1, byte[] var2);

    public static native int serverSecretParamsGenerateDeterministicJNI(byte[] var0, byte[] var1);

    public static native int serverSecretParamsGetPublicParamsJNI(byte[] var0, byte[] var1);

    public static native int serverSecretParamsSignDeterministicJNI(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    public static native int serverSecretParamsCheckValidContentsJNI(byte[] var0);

    public static native int serverPublicParamsReceiveAuthCredentialJNI(byte[] var0, byte[] var1, int var2, byte[] var3, byte[] var4);

    public static native int serverPublicParamsCreateAuthCredentialPresentationDeterministicJNI(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    public static native int serverPublicParamsCreateProfileKeyCredentialRequestContextDeterministicJNI(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    public static native int serverPublicParamsReceiveProfileKeyCredentialJNI(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    public static native int serverPublicParamsCreateProfileKeyCredentialPresentationDeterministicJNI(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    public static native int serverSecretParamsIssueAuthCredentialDeterministicJNI(byte[] var0, byte[] var1, byte[] var2, int var3, byte[] var4);

    public static native int serverSecretParamsVerifyAuthCredentialPresentationJNI(byte[] var0, byte[] var1, byte[] var2);

    public static native int serverSecretParamsIssueProfileKeyCredentialDeterministicJNI(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

    public static native int serverSecretParamsVerifyProfileKeyCredentialPresentationJNI(byte[] var0, byte[] var1, byte[] var2);

    public static native int groupPublicParamsGetGroupIdentifierJNI(byte[] var0, byte[] var1);

    public static native int groupPublicParamsCheckValidContentsJNI(byte[] var0);

    public static native int serverPublicParamsVerifySignatureJNI(byte[] var0, byte[] var1, byte[] var2);

    public static native int serverPublicParamsCheckValidContentsJNI(byte[] var0);

    public static native int authCredentialResponseCheckValidContentsJNI(byte[] var0);

    public static native int authCredentialCheckValidContentsJNI(byte[] var0);

    public static native int authCredentialPresentationGetUuidCiphertextJNI(byte[] var0, byte[] var1);

    public static native int authCredentialPresentationGetRedemptionTimeJNI(byte[] var0, byte[] var1);

    public static native int authCredentialPresentationCheckValidContentsJNI(byte[] var0);

    public static native int profileKeyCredentialRequestContextGetRequestJNI(byte[] var0, byte[] var1);

    public static native int profileKeyCredentialRequestContextCheckValidContentsJNI(byte[] var0);

    public static native int profileKeyCredentialRequestCheckValidContentsJNI(byte[] var0);

    public static native int profileKeyCredentialResponseCheckValidContentsJNI(byte[] var0);

    public static native int profileKeyCredentialCheckValidContentsJNI(byte[] var0);

    public static native int profileKeyCredentialPresentationGetUuidCiphertextJNI(byte[] var0, byte[] var1);

    public static native int profileKeyCredentialPresentationGetProfileKeyCiphertextJNI(byte[] var0, byte[] var1);

    public static native int profileKeyCredentialPresentationCheckValidContentsJNI(byte[] var0);

    public static native int uuidCiphertextCheckValidContentsJNI(byte[] var0);

    public static native int profileKeyCiphertextCheckValidContentsJNI(byte[] var0);

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    static {
        try {
            String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
            boolean isMacOs = osName.startsWith("mac os x");
            String extension = isMacOs ? ".dylib" : ".so";
            try (InputStream in = Native.class.getResourceAsStream("/libzkgroup" + extension);){
                if (in != null) {
                    Native.copyToTempFileAndLoad(in, extension);
                } else {
                    System.loadLibrary("zkgroup");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

