/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.badge4j.badge;

import java.awt.Font;
import java.awt.Toolkit;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.Base64;
import org.silentsoft.badge4j.Brightness;
import org.silentsoft.badge4j.badge.SocialBadge;
import org.silentsoft.simpleicons.Icon;
import org.silentsoft.simpleicons.SimpleIcons;

abstract class Badge {
    private static final double brightnessThreshold = 0.69;
    private static final int horizontalPadding = 5;
    private static final DecimalFormat decimalFormat = new DecimalFormat("###.##");
    protected String label;
    protected String message;
    protected String color;
    protected String labelColor;
    protected String[] links;
    protected String logo;
    protected int logoWidth;
    private String accessibleText;
    Font verdanaFont = new Font("Verdana", 0, 11);

    public Badge(String label, String message, String color, String labelColor, String[] links, String logo, int logoWidth) {
        this.label = label;
        this.message = message;
        this.color = color;
        this.labelColor = labelColor;
        this.links = links;
        this.logo = logo;
        this.logoWidth = logoWidth;
        this.accessibleText = this.createAccessibleText();
        this.adjustColors();
    }

    private void adjustColors() {
        this.labelColor = this.hasLabelOrHasLabelColor() || this.hasLogo() ? this.labelColor : this.color;
        this.labelColor = this.escapeXml(this.labelColor);
        this.color = this.escapeXml(this.color);
    }

    protected int getLabelMargin() {
        return this.getTotalLogoWidth() + 1;
    }

    protected double getLeftWidth() {
        TextData textData = this.renderText(this.getLabelMargin(), 5, this.label, this.hasBothLinks() ? this.getLeftLink() : null, this.getHeight(), this.getVerticalMargin(), this.hasShadow(), this.labelColor);
        int labelWidth = textData.width;
        int leftWidth = this.hasLabelOrHasLabelColor() ? labelWidth + 10 + this.getTotalLogoWidth() : 0;
        return leftWidth;
    }

    protected int getMessageMargin() {
        int messageMargin = (int)this.getLeftWidth() - (this.message != null && this.message.length() > 0 ? 1 : 0);
        if (!this.hasLabelOrHasLabelColor()) {
            messageMargin = this.hasLogo() ? messageMargin + this.getTotalLogoWidth() + 5 : ++messageMargin;
        }
        return messageMargin;
    }

    protected double getRightWidth() {
        TextData textData = this.renderText(this.getMessageMargin(), 5, this.message, this.getRightLink(), this.getHeight(), this.getVerticalMargin(), this.hasShadow(), this.color);
        int messageWidth = textData.width;
        int rightWidth = messageWidth + 10;
        if (this.hasLogo() && !this.hasLabelOrHasLabelColor()) {
            rightWidth += this.getTotalLogoWidth() + 5 - 1;
        }
        return rightWidth;
    }

    private boolean hasLabelOrHasLabelColor() {
        return this.hasLabel();
    }

    protected double getWidth() {
        return this.getLeftWidth() + this.getRightWidth();
    }

    protected abstract int getHeight();

    protected abstract int getVerticalMargin();

    protected abstract boolean hasShadow();

    public abstract String render();

    protected String getFontFamily() {
        return "Verdana,Geneva,DejaVu Sans,sans-serif";
    }

    protected int getLogoPadding() {
        if (this.logo != null && this.message != null && this.message.length() > 0) {
            return 3;
        }
        return 0;
    }

    protected String renderBadge(String main) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"%s\" height=\"%d\" %s>", decimalFormat.format(this.getWidth()), this.getHeight(), this.renderAriaAttributes()));
        builder.append("\n\n");
        builder.append(this.renderTitle());
        builder.append("\n");
        builder.append(this.shouldWrapBodyWithLink() ? String.format("<a target=\"_blank\" xlink:href=\"%s\">%s</a>", this.getLeftLink(), main) : main);
        builder.append("\n");
        builder.append("</svg>");
        return builder.toString();
    }

    protected String renderLogo() {
        return this.renderLogo((String)this.logo, (int)this.getHeight(), (int)5, (int)this.logoWidth).renderedLogo;
    }

    protected int getTotalLogoWidth() {
        return this.renderLogo((String)this.logo, (int)this.getHeight(), (int)5, (int)this.logoWidth).totalLogoWidth;
    }

    protected String renderLabel() {
        return this.renderText((int)this.getLabelMargin(), (int)5, (String)this.label, (String)(this.hasBothLinks() ? this.getLeftLink() : null), (int)this.getHeight(), (int)this.getVerticalMargin(), (boolean)this.hasShadow(), (String)this.labelColor).renderedText;
    }

    protected String renderMessage() {
        return this.renderText((int)this.getMessageMargin(), (int)5, (String)this.message, (String)this.getRightLink(), (int)this.getHeight(), (int)this.getVerticalMargin(), (boolean)this.hasShadow(), (String)this.color).renderedText;
    }

    protected LogoData renderLogo(String logo, int badgeHeight, int horizPadding, int logoWidth) {
        LogoData logoData = new LogoData();
        boolean nothingToRender = false;
        if (logo != null && logo.length() > 0) {
            int logoHeight = 14;
            int y = (badgeHeight - logoHeight) / 2;
            int x = horizPadding;
            logoData.hasLogo = true;
            logoData.totalLogoWidth = logoWidth + this.getLogoPadding();
            String base64 = this.encodeLogoToBase64(logo);
            if (base64 != null) {
                logoData.renderedLogo = String.format("<image x=\"%d\" y=\"%d\" width=\"%d\" height=\"%d\" xlink:href=\"%s\"/>", x, y, logoWidth, logoHeight, base64);
            } else {
                nothingToRender = true;
            }
        } else {
            nothingToRender = true;
        }
        if (nothingToRender) {
            logoData.hasLogo = false;
            logoData.totalLogoWidth = 0;
            logoData.renderedLogo = "";
        }
        return logoData;
    }

    protected String encodeLogoToBase64(String logo) {
        if (logo.startsWith("data:")) {
            return this.escapeXml(logo);
        }
        Icon simpleIcon = SimpleIcons.get((String)logo);
        if (simpleIcon != null && simpleIcon.getSvg() != null && simpleIcon.getSvg().length() > 0) {
            String svg = simpleIcon.getSvg();
            String adjustedColor = null;
            if (simpleIcon.getHex() != null && simpleIcon.getHex().length() > 0) {
                String logoColor;
                String string = logoColor = simpleIcon.getHex().startsWith("#") ? simpleIcon.getHex() : "#".concat(simpleIcon.getHex());
                adjustedColor = this instanceof SocialBadge && Brightness.of(logoColor) >= 0.6 ? "#333" : (!(this instanceof SocialBadge) && Brightness.of(logoColor) <= 0.4 ? "whitesmoke" : logoColor);
            }
            if (adjustedColor != null) {
                svg = svg.replace("<svg", String.format("<svg fill=\"%s\"", adjustedColor));
            }
            return "data:image/svg+xml;base64,".concat(Base64.getEncoder().encodeToString(svg.getBytes(StandardCharsets.UTF_8)));
        }
        return null;
    }

    protected String renderLink(String link, int height, int textLength, int horizPadding, int leftMargin, String renderedText) {
        int rectHeight = height;
        int rectWidth = textLength + horizPadding * 2;
        int rectX = leftMargin > 1 ? leftMargin + 1 : 0;
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("<a target=\"_blank\" xlink:href=\"%s\">", this.escapeXml(link)));
        builder.append("\n");
        builder.append("\t");
        builder.append(String.format("<rect width=\"%d\" x=\"%d\" height=\"%d\" fill=\"rgba(0,0,0,0)\" />", rectWidth, rectX, rectHeight));
        builder.append("\n");
        builder.append("\t");
        builder.append(renderedText);
        builder.append("</a>");
        return builder.toString();
    }

    protected TextData renderText(int leftMargin, int horizPadding, String content, String link, int height, int verticalMargin, boolean shadow, String color) {
        TextData textData = new TextData();
        if (content == null || "".equals(content)) {
            textData.renderedText = "";
            textData.width = 0;
            return textData;
        }
        int textLength = this.preferredWidthOf(content, this.verdanaFont);
        String escapedContent = this.escapeXml(content);
        int shadowMargin = 150 + verticalMargin;
        int textMargin = 140 + verticalMargin;
        int outTextLength = 10 * textLength;
        int x = (int)(10.0 * ((double)leftMargin + 0.5 * (double)textLength + (double)horizPadding));
        String renderedText = "";
        BackgroundColorData backgroundColorData = this.colorsForBackground(color);
        if (shadow) {
            renderedText = String.format("<text aria-hidden=\"true\" x=\"%d\" y=\"%d\" fill=\"%s\" fill-opacity=\".3\" transform=\"scale(.1)\" textLength=\"%d\">%s</text>", x, shadowMargin, backgroundColorData.shadowColor, outTextLength, escapedContent);
        }
        renderedText = renderedText + String.format("<text x=\"%d\" y=\"%d\" transform=\"scale(.1)\" fill=\"%s\" textLength=\"%d\">%s</text>", x, textMargin, backgroundColorData.textColor, outTextLength, escapedContent);
        textData.renderedText = link != null && link.length() > 0 ? this.renderLink(link, height, textLength, horizPadding, leftMargin, renderedText) : renderedText;
        textData.width = textLength;
        return textData;
    }

    protected BackgroundColorData colorsForBackground(String color) {
        BackgroundColorData backgroundColorData = new BackgroundColorData();
        if (Brightness.of(color) <= 0.69) {
            backgroundColorData.textColor = "#fff";
            backgroundColorData.shadowColor = "#010101";
        } else {
            backgroundColorData.textColor = "#333";
            backgroundColorData.shadowColor = "#ccc";
        }
        return backgroundColorData;
    }

    protected int preferredWidthOf(String content, Font font) {
        int width = Toolkit.getDefaultToolkit().getFontMetrics(font).stringWidth(content);
        return this.roundUpToOdd(width);
    }

    private int roundUpToOdd(int value) {
        return value % 2 == 0 ? value + 1 : value;
    }

    protected String escapeXml(String value) {
        value = value.replaceAll("&", "&amp;");
        value = value.replaceAll("<", "&lt;");
        value = value.replaceAll(">", "&gt;");
        value = value.replaceAll("\"", "&quot;");
        value = value.replaceAll("'", "&apos;");
        return value;
    }

    protected boolean hasBothLinks() {
        return this.hasLeftLink() && this.hasRightLink();
    }

    protected boolean hasLeftLink() {
        return this.links != null && this.links.length >= 1 && this.links[0] != null && this.links[0].length() > 0;
    }

    protected boolean hasRightLink() {
        return this.links != null && this.links.length >= 2 && this.links[1] != null && this.links[1].length() > 0;
    }

    protected String getLeftLink() {
        return this.hasLeftLink() ? this.escapeXml(this.links[0]) : null;
    }

    protected String getRightLink() {
        return this.hasRightLink() ? this.escapeXml(this.links[1]) : null;
    }

    private String renderAriaAttributes() {
        return this.hasBothLinks() ? "" : String.format("role=\"img\" aria-label=\"%s\"", this.escapeXml(this.accessibleText));
    }

    private String renderTitle() {
        return this.hasBothLinks() ? "" : String.format("<title>%s</title>", this.escapeXml(this.accessibleText));
    }

    protected boolean shouldWrapBodyWithLink() {
        return this.hasOnlyOneLink();
    }

    protected boolean hasOnlyOneLink() {
        return this.hasLeftLink() && !this.hasRightLink();
    }

    private String createAccessibleText() {
        String labelPrefix = this.label != null && this.label.length() > 0 ? this.label.concat(": ") : "";
        return labelPrefix.concat(this.message);
    }

    protected String toString(double number) {
        return decimalFormat.format(number);
    }

    protected boolean hasLogo() {
        return this.isNotEmpty(this.logo);
    }

    protected boolean hasLabel() {
        return this.isNotEmpty(this.label);
    }

    private boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }

    private boolean isNotEmpty(String value) {
        return !this.isEmpty(value);
    }

    class BackgroundColorData {
        String textColor;
        String shadowColor;

        BackgroundColorData() {
        }
    }

    class TextData {
        String renderedText;
        int width;

        TextData() {
        }
    }

    class LogoData {
        boolean hasLogo;
        int totalLogoWidth;
        String renderedLogo;

        LogoData() {
        }
    }
}

