/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.badge4j.badge;

import java.awt.Font;
import org.silentsoft.badge4j.badge.Badge;

public class ForTheBadge
extends Badge {
    private static final int FONT_SIZE = 10;
    private static final int BADGE_HEIGHT = 28;
    private static final int LOGO_HEIGHT = 14;
    private static final int TEXT_MARGIN = 12;
    private static final int LOGO_MARGIN = 9;
    private static final int LOGO_TEXT_GUTTER = 6;
    private static final double LETTER_SPACING = 1.25;
    private static int FONT_SCALE_UP_FACTOR = 10;
    private double labelTextWidth;
    private double messageTextWidth;
    private boolean needsLabelRect;
    private int logoMinX;
    private int labelTextMinX;
    private double labelRectWidth;
    private double messageTextMinX;
    private double messageRectWidth;

    public ForTheBadge(String label, String message, String color, String labelColor, String[] links, String logo, int logoWidth) {
        super(label, message, color, labelColor, links, logo, logoWidth);
        this.labelTextWidth = label == null || "".equals(label) ? 0.0 : (double)this.preferredWidthOf(label, new Font("Verdana", 0, 10)) + 1.25 * (double)label.length();
        this.messageTextWidth = message == null || "".equals(message) ? 0.0 : (double)this.preferredWidthOf(message, new Font("Verdana", 1, 10)) + 1.25 * (double)message.length();
        boolean bl = this.needsLabelRect = this.hasLabel() || logo != null && logo.length() > 0 && labelColor != null && labelColor.length() > 0;
        if (logo != null && logo.length() > 0) {
            this.logoMinX = 9;
            this.labelTextMinX = this.logoMinX + logoWidth + 6;
        } else {
            this.labelTextMinX = 12;
        }
        if (this.needsLabelRect) {
            this.labelRectWidth = this.hasLabel() ? (double)this.labelTextMinX + this.labelTextWidth + 12.0 : (double)(18 + logoWidth);
            this.messageTextMinX = this.labelRectWidth + 12.0;
            this.messageRectWidth = 24.0 + this.messageTextWidth;
        } else if (logo != null && logo.length() > 0) {
            this.messageTextMinX = 12 + logoWidth + 6;
            this.messageRectWidth = (double)(24 + logoWidth + 6) + this.messageTextWidth;
        } else {
            this.messageTextMinX = 12.0;
            this.messageRectWidth = 24.0 + this.messageTextWidth;
        }
    }

    @Override
    protected double getLeftWidth() {
        return this.labelRectWidth;
    }

    @Override
    protected double getRightWidth() {
        return this.messageRectWidth;
    }

    @Override
    protected String renderLogo() {
        if (this.hasLogo()) {
            return String.format("<image x=\"%d\" y=\"%.1f\" width=\"%d\" height=\"%d\" xlink:href=\"%s\"/>", this.logoMinX, 7.0, this.logoWidth, 14, this.encodeLogoToBase64(this.logo));
        }
        return "";
    }

    @Override
    protected int getHeight() {
        return 28;
    }

    @Override
    protected int getVerticalMargin() {
        return 0;
    }

    @Override
    protected boolean hasShadow() {
        return false;
    }

    @Override
    public String render() {
        return this.renderBadge(String.join((CharSequence)"", this.renderBackground(), this.renderForeground()));
    }

    private String renderLabelText() {
        String textColor = this.colorsForBackground((String)this.labelColor).textColor;
        double midX = (double)this.labelTextMinX + 0.5 * this.labelTextWidth;
        String text = String.format("<text transform=\"scale(.1)\" x=\"%s\" y=\"175\" textLength=\"%s\" fill=\"%s\">%s</text>", this.toString((double)FONT_SCALE_UP_FACTOR * midX), this.toString((double)FONT_SCALE_UP_FACTOR * this.labelTextWidth), textColor, this.label);
        StringBuilder builder = new StringBuilder();
        if (this.hasLeftLink() && !this.shouldWrapBodyWithLink()) {
            builder.append(String.format("<a target=\"_blank\" xlink:href=\"%s\">", this.getLeftLink()));
            builder.append(String.format("<rect width=\"%.2f\" height=\"%d\" fill=\"rgba(0,0,0,0)\" />", this.labelRectWidth, 28));
            builder.append(text);
            builder.append("</a>");
        } else {
            builder.append(text);
        }
        return builder.toString();
    }

    private String renderMessageText() {
        String textColor = this.colorsForBackground((String)this.color).textColor;
        double midX = this.messageTextMinX + 0.5 * this.messageTextWidth;
        String text = String.format("<text transform=\"scale(.1)\" x=\"%.2f\" y=\"175\" textLength=\"%.1f\" fill=\"%s\" font-weight=\"bold\">%s</text>", (double)FONT_SCALE_UP_FACTOR * midX, (double)FONT_SCALE_UP_FACTOR * this.messageTextWidth, textColor, this.message);
        StringBuilder builder = new StringBuilder();
        if (this.hasRightLink()) {
            builder.append(String.format("<a target=\"_blank\" xlink:href=\"%s\">", this.getRightLink()));
            builder.append(String.format("<rect width=\"%.2f\" height=\"%d\" x=\"%.2f\" fill=\"rgba(0,0,0,0)\" />", this.messageRectWidth, 28, this.labelRectWidth));
            builder.append(text);
            builder.append("</a>");
        } else {
            builder.append(text);
        }
        return builder.toString();
    }

    private String renderBackground() {
        StringBuilder builder = new StringBuilder();
        builder.append("<g shape-rendering=\"crispEdges\">");
        if (this.needsLabelRect) {
            builder.append(String.format("<rect width=\"%.2f\" height=\"%d\" fill=\"%s\" />", this.labelRectWidth, 28, this.labelColor));
            builder.append(String.format("<rect x=\"%.2f\" width=\"%.2f\" height=\"%d\" fill=\"%s\" />", this.labelRectWidth, this.messageRectWidth, 28, this.color));
        } else {
            builder.append(String.format("<rect width=\"%.2f\" height=\"%d\" fill=\"%s\" />", this.messageRectWidth, 28, this.color));
        }
        builder.append("</g>");
        return builder.toString();
    }

    private String renderForeground() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("<g fill=\"#fff\" text-anchor=\"middle\" font-family=\"%s\" text-rendering=\"geometricPrecision\" font-size=\"%d\">", this.getFontFamily(), FONT_SCALE_UP_FACTOR * 10));
        builder.append(this.hasLogo() ? this.renderLogo() : "");
        builder.append(this.hasLabel() ? this.renderLabelText() : "");
        builder.append(this.renderMessageText());
        builder.append("</g>");
        return builder.toString();
    }
}

