/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.badge4j.badge;

import java.awt.Font;
import org.silentsoft.badge4j.badge.Badge;

public class SocialBadge
extends Badge {
    private int externalHeight = 20;
    private int internalHeight = 19;
    private int labelHorizPadding = 5;
    private int labelRectWidth;
    private boolean hasMessage;
    private int horizGutter = 6;
    private int messageRectWidth;
    private int totalLogoWidth;
    private int labelTextWidth;
    private int messageTextWidth;
    private String renderedLogo;

    public SocialBadge(String label, String message, String color, String labelColor, String[] links, String logo, int logoWidth) {
        super(label, message, color, labelColor, links, logo, logoWidth);
        Badge.LogoData logoData = this.renderLogo(logo, this.externalHeight, this.labelHorizPadding, logoWidth);
        this.totalLogoWidth = logoData.totalLogoWidth;
        this.renderedLogo = logoData.renderedLogo;
        this.hasMessage = message != null && message.length() > 0;
        Font font = new Font("Helvetica", 1, 11);
        this.labelTextWidth = this.preferredWidthOf(label, font);
        this.messageTextWidth = this.preferredWidthOf(message, font);
        this.labelRectWidth = this.labelTextWidth + logoData.totalLogoWidth + 2 * this.labelHorizPadding;
        int messageHorizPadding = 4;
        this.messageRectWidth = this.messageTextWidth + 2 * messageHorizPadding;
    }

    @Override
    protected double getLeftWidth() {
        return this.labelRectWidth + 1;
    }

    @Override
    protected double getRightWidth() {
        return this.hasMessage ? (double)(this.horizGutter + this.messageRectWidth) : 0.0;
    }

    @Override
    protected String renderLogo() {
        return this.renderedLogo;
    }

    @Override
    protected String getFontFamily() {
        return "Helvetica Neue,Helvetica,Arial,sans-serif";
    }

    @Override
    protected int getHeight() {
        return this.externalHeight;
    }

    @Override
    protected int getVerticalMargin() {
        return 0;
    }

    @Override
    protected boolean hasShadow() {
        return false;
    }

    @Override
    public String render() {
        StringBuilder builder = new StringBuilder();
        builder.append("<style>a:hover #llink{fill:url(#b);stroke:#ccc}a:hover #rlink{fill:#4183c4}</style>");
        builder.append("<linearGradient id=\"a\" x2=\"0\" y2=\"100%\">");
        builder.append("<stop offset=\"0\" stop-color=\"#fcfcfc\" stop-opacity=\"0\"/>");
        builder.append("<stop offset=\"1\" stop-opacity=\".1\"/>");
        builder.append("</linearGradient>");
        builder.append("<linearGradient id=\"b\" x2=\"0\" y2=\"100%\">");
        builder.append("<stop offset=\"0\" stop-color=\"#ccc\" stop-opacity=\".1\"/>");
        builder.append("<stop offset=\"1\" stop-opacity=\".1\"/>");
        builder.append("</linearGradient>");
        builder.append("<g stroke=\"#d5d5d5\">");
        builder.append(String.format("<rect stroke=\"none\" fill=\"#fcfcfc\" x=\"0.5\" y=\"0.5\" width=\"%d\" height=\"%d\" rx=\"2\"/>", this.labelRectWidth, this.internalHeight));
        builder.append(this.hasMessage ? this.renderMessageBubble() : "");
        builder.append("</g>");
        builder.append(this.renderLogo());
        builder.append(String.format("<g aria-hidden=\"%s\" fill=\"#333\" text-anchor=\"middle\" font-family=\"%s\" text-rendering=\"geometricPrecision\" font-weight=\"700\" font-size=\"110px\" line-height=\"14px\">", !this.hasBothLinks(), this.getFontFamily()));
        builder.append(this.renderLabelText());
        builder.append(this.hasMessage ? this.renderMessageText() : "");
        builder.append("</g>");
        return this.renderBadge(builder.toString());
    }

    private String renderMessageBubble() {
        double messageBubbleMainX = (double)(this.labelRectWidth + this.horizGutter) + 0.5;
        int messageBubbleNotchX = this.labelRectWidth + this.horizGutter;
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("<rect x=\"%.1f\" y=\"0.5\" width=\"%d\" height=\"%d\" rx=\"2\" fill=\"#fafafa\"/>", messageBubbleMainX, this.messageRectWidth, this.internalHeight));
        builder.append(String.format("<rect x=\"%d\" y=\"7.5\" width=\"0.5\" height=\"5\" stroke=\"#fafafa\"/>", messageBubbleNotchX));
        builder.append(String.format("<path d=\"M%.1f 6.5 l-3 3v1 l3 3\" stroke=\"d5d5d5\" fill=\"#fafafa\"/>", messageBubbleMainX));
        return builder.toString();
    }

    private String renderLabelText() {
        int labelTextX = 10 * (this.totalLogoWidth + this.labelTextWidth / 2 + this.labelHorizPadding);
        int labelTextLength = 10 * this.labelTextWidth;
        String escapedLabel = this.escapeXml(this.label);
        boolean shouldWrapWithLink = this.hasLeftLink() && !this.shouldWrapBodyWithLink();
        String rect = String.format("<rect id=\"llink\" stroke=\"#d5d5d5\" fill=\"url(#a)\" x=\".5\" y=\".5\" width=\"%d\" height=\"%d\" rx=\"2\" />", this.labelRectWidth, this.internalHeight);
        String shadow = String.format("<text aria-hidden=\"true\" x=\"%d\" y=\"150\" fill=\"#fff\" transform=\"scale(.1)\" textLength=\"%d\">%s</text>", labelTextX, labelTextLength, escapedLabel);
        String text = String.format("<text x=\"%d\" y=\"140\" transform=\"scale(.1)\" textLength=\"%d\">%s</text>", labelTextX, labelTextLength, escapedLabel);
        StringBuilder builder = new StringBuilder();
        if (shouldWrapWithLink) {
            builder.append(String.format("<a target=\"_blank\" xlink:href=\"%s\">", this.getLeftLink()));
            builder.append(shadow);
            builder.append(text);
            builder.append(rect);
            builder.append("</a>");
        } else {
            builder.append(rect);
            builder.append(shadow);
            builder.append(text);
        }
        return builder.toString();
    }

    private String renderMessageText() {
        int messageTextX = 10 * (this.labelRectWidth + this.horizGutter + this.messageRectWidth / 2);
        int messageTextLength = 10 * this.messageTextWidth;
        String escapedMessage = this.escapeXml(this.message);
        String rect = String.format("<rect width=\"%d\" x=\"%d\" height=\"%d\" fill=\"rgba(0,0,0,0)\" />", this.messageRectWidth + 1, this.labelRectWidth + this.horizGutter, this.internalHeight + 1);
        String shadow = String.format("<text aria-hidden=\"true\" x=\"%d\" y=\"150\" fill=\"#fff\" transform=\"scale(.1)\" textLength=\"%d\">%s</text>", messageTextX, messageTextLength, escapedMessage);
        String text = String.format("<text id=\"rlink\" x=\"%d\" y=\"140\" transform=\"scale(.1)\" textLength=\"%d\">%s</text>", messageTextX, messageTextLength, escapedMessage);
        StringBuilder builder = new StringBuilder();
        if (this.hasRightLink()) {
            builder.append(String.format("<a target=\"_blank\" xlink:href=\"%s\">", this.getRightLink()));
            builder.append(rect);
            builder.append(shadow);
            builder.append(text);
        } else {
            builder.append(shadow);
            builder.append(text);
        }
        return builder.toString();
    }
}

