/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import java.util.Arrays;
import org.simdjson.BitIndexes;
import org.simdjson.JsonParsingException;
import org.simdjson.JsonValue;
import org.simdjson.TapeBuilder;

class JsonIterator {
    private static final int OBJECT_BEGIN = 0;
    private static final int ARRAY_BEGIN = 1;
    private static final int DOCUMENT_END = 2;
    private static final int OBJECT_FIELD = 3;
    private static final int OBJECT_CONTINUE = 4;
    private static final int SCOPE_END = 5;
    private static final int ARRAY_CONTINUE = 6;
    private static final int ARRAY_VALUE = 7;
    private final TapeBuilder tapeBuilder;
    private final BitIndexes indexer;
    private final boolean[] isArray;

    JsonIterator(BitIndexes indexer, int capacity, int maxDepth, int padding) {
        this.indexer = indexer;
        this.isArray = new boolean[maxDepth];
        this.tapeBuilder = new TapeBuilder(capacity, maxDepth, padding);
    }

    JsonValue walkDocument(byte[] buffer, int len) {
        this.tapeBuilder.visitDocumentStart();
        int depth = 0;
        int idx = this.indexer.advance();
        int state = switch (buffer[idx]) {
            case 123 -> {
                if (buffer[this.indexer.peek()] == 125) {
                    this.indexer.advance();
                    this.tapeBuilder.visitEmptyObject();
                    yield 2;
                }
                yield 0;
            }
            case 91 -> {
                if (buffer[this.indexer.peek()] == 93) {
                    this.indexer.advance();
                    this.tapeBuilder.visitEmptyArray();
                    yield 2;
                }
                yield 1;
            }
            default -> {
                this.tapeBuilder.visitRootPrimitive(buffer, idx, len);
                yield 2;
            }
        };
        while (this.indexer.hasNext()) {
            int keyIdx;
            if (state == 0) {
                this.isArray[++depth] = false;
                this.tapeBuilder.visitObjectStart(depth);
                keyIdx = this.indexer.advance();
                if (buffer[keyIdx] != 34) {
                    throw new JsonParsingException("Object does not start with a key");
                }
                this.tapeBuilder.incrementCount(depth);
                this.tapeBuilder.visitKey(buffer, keyIdx);
                state = 3;
            }
            if (state == 3) {
                if (buffer[this.indexer.advance()] != 58) {
                    throw new JsonParsingException("Missing colon after key in object");
                }
                idx = this.indexer.advance();
                switch (buffer[idx]) {
                    case 123: {
                        if (buffer[this.indexer.peek()] == 125) {
                            this.indexer.advance();
                            this.tapeBuilder.visitEmptyObject();
                            state = 4;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 91: {
                        if (buffer[this.indexer.peek()] == 93) {
                            this.indexer.advance();
                            this.tapeBuilder.visitEmptyArray();
                            state = 4;
                            break;
                        }
                        state = 1;
                        break;
                    }
                    default: {
                        this.tapeBuilder.visitPrimitive(buffer, idx);
                        state = 4;
                    }
                }
            }
            if (state == 4) {
                switch (buffer[this.indexer.advance()]) {
                    case 44: {
                        this.tapeBuilder.incrementCount(depth);
                        keyIdx = this.indexer.advance();
                        if (buffer[keyIdx] != 34) {
                            throw new JsonParsingException("Key string missing at beginning of field in object");
                        }
                        this.tapeBuilder.visitKey(buffer, keyIdx);
                        state = 3;
                        break;
                    }
                    case 125: {
                        this.tapeBuilder.visitObjectEnd(depth);
                        state = 5;
                        break;
                    }
                    default: {
                        throw new JsonParsingException("No comma between object fields");
                    }
                }
            }
            if (state == 5) {
                state = --depth == 0 ? 2 : (this.isArray[depth] ? 6 : 4);
            }
            if (state == 1) {
                this.isArray[++depth] = true;
                this.tapeBuilder.visitArrayStart(depth);
                this.tapeBuilder.incrementCount(depth);
                state = 7;
            }
            if (state == 7) {
                idx = this.indexer.advance();
                switch (buffer[idx]) {
                    case 123: {
                        if (buffer[this.indexer.peek()] == 125) {
                            this.indexer.advance();
                            this.tapeBuilder.visitEmptyObject();
                            state = 6;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 91: {
                        if (buffer[this.indexer.peek()] == 93) {
                            this.indexer.advance();
                            this.tapeBuilder.visitEmptyArray();
                            state = 6;
                            break;
                        }
                        state = 1;
                        break;
                    }
                    default: {
                        this.tapeBuilder.visitPrimitive(buffer, idx);
                        state = 6;
                    }
                }
            }
            if (state == 6) {
                switch (buffer[this.indexer.advance()]) {
                    case 44: {
                        this.tapeBuilder.incrementCount(depth);
                        state = 7;
                        break;
                    }
                    case 93: {
                        this.tapeBuilder.visitArrayEnd(depth);
                        state = 5;
                        break;
                    }
                    default: {
                        throw new JsonParsingException("Missing comma between array values");
                    }
                }
            }
            if (state != 2) continue;
            this.tapeBuilder.visitDocumentEnd();
            if (this.indexer.isEnd()) continue;
            throw new JsonParsingException("More than one JSON value at the root of the document, or extra characters at the end of the JSON!");
        }
        return this.tapeBuilder.createJsonValue(buffer);
    }

    void reset() {
        this.tapeBuilder.reset();
        Arrays.fill(this.isArray, false);
    }
}

