/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import jdk.incubator.vector.ByteVector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;
import org.simdjson.BitIndexes;
import org.simdjson.CharactersClassifier;
import org.simdjson.JsonCharacterBlock;
import org.simdjson.JsonParsingException;
import org.simdjson.JsonStringBlock;
import org.simdjson.JsonStringScanner;

class StructuralIndexer {
    static final VectorSpecies<Byte> SPECIES;
    static final int N_CHUNKS;
    private final JsonStringScanner stringScanner = new JsonStringScanner();
    private final CharactersClassifier classifier = new CharactersClassifier();
    private final BitIndexes bitIndexes;
    private long prevStructurals = 0L;
    private long unescapedCharsError = 0L;
    private long prevScalar = 0L;

    StructuralIndexer(BitIndexes bitIndexes) {
        this.bitIndexes = bitIndexes;
    }

    void step(byte[] buffer, int offset, int blockIndex) {
        switch (N_CHUNKS) {
            case 1: {
                this.step1(buffer, offset, blockIndex);
                break;
            }
            case 2: {
                this.step2(buffer, offset, blockIndex);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported vector width: " + N_CHUNKS * 64);
            }
        }
    }

    private void step1(byte[] buffer, int offset, int blockIndex) {
        ByteVector chunk0 = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_512, (byte[])buffer, (int)offset);
        JsonStringBlock strings = this.stringScanner.next(chunk0);
        JsonCharacterBlock characters = this.classifier.classify(chunk0);
        long unescaped = this.lteq(chunk0, (byte)31);
        this.finishStep(characters, strings, unescaped, blockIndex);
    }

    private void step2(byte[] buffer, int offset, int blockIndex) {
        ByteVector chunk0 = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_256, (byte[])buffer, (int)offset);
        ByteVector chunk1 = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_256, (byte[])buffer, (int)(offset + 32));
        JsonStringBlock strings = this.stringScanner.next(chunk0, chunk1);
        JsonCharacterBlock characters = this.classifier.classify(chunk0, chunk1);
        long unescaped = this.lteq(chunk0, chunk1, (byte)31);
        this.finishStep(characters, strings, unescaped, blockIndex);
    }

    private void finishStep(JsonCharacterBlock characters, JsonStringBlock strings, long unescaped, int blockIndex) {
        long scalar = characters.scalar();
        long nonQuoteScalar = scalar & (strings.quote() ^ 0xFFFFFFFFFFFFFFFFL);
        long followsNonQuoteScalar = nonQuoteScalar << 1 | this.prevScalar;
        this.prevScalar = nonQuoteScalar >>> 63;
        long potentialScalarStart = scalar & (followsNonQuoteScalar ^ 0xFFFFFFFFFFFFFFFFL);
        long potentialStructuralStart = characters.op() | potentialScalarStart;
        this.bitIndexes.write(blockIndex, this.prevStructurals);
        this.prevStructurals = potentialStructuralStart & (strings.stringTail() ^ 0xFFFFFFFFFFFFFFFFL);
        this.unescapedCharsError |= strings.nonQuoteInsideString(unescaped);
    }

    private long lteq(ByteVector chunk0, byte scalar) {
        long r = chunk0.compare(VectorOperators.UNSIGNED_LE, scalar).toLong();
        return r;
    }

    private long lteq(ByteVector chunk0, ByteVector chunk1, byte scalar) {
        long r0 = chunk0.compare(VectorOperators.UNSIGNED_LE, scalar).toLong();
        long r1 = chunk1.compare(VectorOperators.UNSIGNED_LE, scalar).toLong();
        return r0 | r1 << 32;
    }

    void finish(int blockIndex) {
        this.bitIndexes.write(blockIndex, this.prevStructurals);
        this.stringScanner.finish();
        if (this.unescapedCharsError != 0L) {
            throw new JsonParsingException("Unescaped characters. Within strings, there are characters that should be escaped.");
        }
    }

    void reset() {
        this.stringScanner.reset();
        this.prevStructurals = 0L;
        this.unescapedCharsError = 0L;
        this.prevScalar = 0L;
    }

    static {
        String species;
        SPECIES = switch (species = System.getProperty("org.simdjson.species", "preferred")) {
            case "preferred" -> ByteVector.SPECIES_PREFERRED;
            case "512" -> ByteVector.SPECIES_512;
            case "256" -> ByteVector.SPECIES_256;
            default -> throw new IllegalArgumentException("Unsupported vector species: " + species);
        };
        N_CHUNKS = 64 / SPECIES.vectorByteSize();
        if (SPECIES != ByteVector.SPECIES_256 && SPECIES != ByteVector.SPECIES_512) {
            throw new IllegalArgumentException("Unsupported vector species: " + SPECIES);
        }
    }
}

