/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import java.util.Arrays;
import org.simdjson.BitIndexes;
import org.simdjson.CharacterUtils;
import org.simdjson.JsonParsingException;
import org.simdjson.NumberParser;
import org.simdjson.StringParser;

class OnDemandJsonIterator {
    private static final byte SPACE = 32;
    private static final int[] SKIP_DEPTH_PER_CHARACTER = new int[127];
    private final BitIndexes indexer;
    private final int padding;
    private final StringParser stringParser = new StringParser();
    private final NumberParser numberParser = new NumberParser();
    private byte[] buffer;
    private int len;
    private int depth;

    OnDemandJsonIterator(BitIndexes indexer, int padding) {
        this.indexer = indexer;
        this.padding = padding;
    }

    void init(byte[] buffer, int len) {
        if (this.indexer.isEnd()) {
            throw new JsonParsingException("No structural element found.");
        }
        this.buffer = buffer;
        this.len = len;
        this.depth = 1;
    }

    void skipChild() {
        this.skipChild(this.depth - 1);
    }

    void skipChild(int parentDepth) {
        if (this.depth <= parentDepth) {
            return;
        }
        int idx = this.indexer.getAndAdvance();
        byte character = this.buffer[idx];
        switch (character) {
            case 44: 
            case 58: 
            case 91: 
            case 123: {
                break;
            }
            case 34: {
                if (this.buffer[this.indexer.peek()] == 58) {
                    this.indexer.advance();
                    break;
                }
            }
            default: {
                --this.depth;
                if (this.depth > parentDepth) break;
                return;
            }
        }
        while (this.indexer.hasNext()) {
            idx = this.indexer.getAndAdvance();
            character = this.buffer[idx];
            int delta = SKIP_DEPTH_PER_CHARACTER[character];
            this.depth += delta;
            if (delta >= 0 || this.depth > parentDepth) continue;
            return;
        }
        throw new JsonParsingException("Not enough close braces.");
    }

    Boolean getRootNonNullBoolean() {
        int idx = this.indexer.getAndAdvance();
        Boolean result = switch (this.buffer[idx]) {
            case 116 -> this.visitRootTrueAtom(idx);
            case 102 -> this.visitRootFalseAtom(idx);
            default -> throw new JsonParsingException("Unrecognized boolean value. Expected: 'true' or 'false'.");
        };
        this.assertNoMoreJsonValues();
        --this.depth;
        return result;
    }

    Boolean getRootBoolean() {
        int idx = this.indexer.getAndAdvance();
        Boolean result = switch (this.buffer[idx]) {
            case 116 -> this.visitRootTrueAtom(idx);
            case 102 -> this.visitRootFalseAtom(idx);
            case 110 -> {
                this.visitRootNullAtom(idx);
                yield null;
            }
            default -> throw new JsonParsingException("Unrecognized boolean value. Expected: 'true', 'false' or 'null'.");
        };
        this.assertNoMoreJsonValues();
        --this.depth;
        return result;
    }

    private Boolean visitRootTrueAtom(int idx) {
        boolean valid;
        boolean bl = valid = idx + 4 <= this.len && this.isTrue(idx) && (idx + 4 == this.len || CharacterUtils.isStructuralOrWhitespace(this.buffer[idx + 4]));
        if (!valid) {
            throw new JsonParsingException("Invalid value starting at " + idx + ". Expected 'true'.");
        }
        return Boolean.TRUE;
    }

    private Boolean visitRootFalseAtom(int idx) {
        boolean valid;
        boolean bl = valid = idx + 5 <= this.len && this.isFalse(idx) && (idx + 5 == this.len || CharacterUtils.isStructuralOrWhitespace(this.buffer[idx + 5]));
        if (!valid) {
            throw new JsonParsingException("Invalid value starting at " + idx + ". Expected 'false'.");
        }
        return Boolean.FALSE;
    }

    private void visitRootNullAtom(int idx) {
        boolean valid;
        boolean bl = valid = idx + 4 <= this.len && this.isNull(idx) && (idx + 4 == this.len || CharacterUtils.isStructuralOrWhitespace(this.buffer[idx + 4]));
        if (!valid) {
            throw new JsonParsingException("Invalid value starting at " + idx + ". Expected 'null'.");
        }
    }

    private void visitNullAtom(int idx) {
        if (!this.isNull(idx)) {
            throw new JsonParsingException("Invalid value starting at " + idx + ". Expected 'null'.");
        }
    }

    private boolean isNull(int idx) {
        return this.buffer[idx] == 110 && this.buffer[idx + 1] == 117 && this.buffer[idx + 2] == 108 && this.buffer[idx + 3] == 108;
    }

    Boolean getNonNullBoolean() {
        int idx = this.indexer.getAndAdvance();
        Boolean result = switch (this.buffer[idx]) {
            case 116 -> this.visitTrueAtom(idx);
            case 102 -> this.visitFalseAtom(idx);
            default -> throw new JsonParsingException("Unrecognized boolean value. Expected: 'true' or 'false'.");
        };
        --this.depth;
        return result;
    }

    Boolean getBoolean() {
        int idx = this.indexer.getAndAdvance();
        Boolean result = switch (this.buffer[idx]) {
            case 116 -> this.visitTrueAtom(idx);
            case 102 -> this.visitFalseAtom(idx);
            case 110 -> {
                this.visitNullAtom(idx);
                yield null;
            }
            default -> throw new JsonParsingException("Unrecognized boolean value. Expected: 'true', 'false' or 'null'.");
        };
        --this.depth;
        return result;
    }

    private Boolean visitTrueAtom(int idx) {
        boolean valid;
        boolean bl = valid = this.isTrue(idx) && CharacterUtils.isStructuralOrWhitespace(this.buffer[idx + 4]);
        if (!valid) {
            throw new JsonParsingException("Invalid value starting at " + idx + ". Expected 'true'.");
        }
        return Boolean.TRUE;
    }

    private boolean isTrue(int idx) {
        return this.buffer[idx] == 116 && this.buffer[idx + 1] == 114 && this.buffer[idx + 2] == 117 && this.buffer[idx + 3] == 101;
    }

    private Boolean visitFalseAtom(int idx) {
        boolean valid;
        boolean bl = valid = this.isFalse(idx) && CharacterUtils.isStructuralOrWhitespace(this.buffer[idx + 5]);
        if (!valid) {
            throw new JsonParsingException("Invalid value starting at " + idx + ". Expected 'false'.");
        }
        return Boolean.FALSE;
    }

    private boolean isFalse(int idx) {
        return this.buffer[idx] == 102 && this.buffer[idx + 1] == 97 && this.buffer[idx + 2] == 108 && this.buffer[idx + 3] == 115 && this.buffer[idx + 4] == 101;
    }

    byte getRootNonNullByte() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        byte[] copy = this.padRootNumber(idx);
        byte value = this.numberParser.parseByte(copy, this.len, 0);
        this.assertNoMoreJsonValues();
        return value;
    }

    Byte getRootByte() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        if (this.buffer[idx] == 110) {
            this.visitRootNullAtom(idx);
            this.assertNoMoreJsonValues();
            return null;
        }
        byte[] copy = this.padRootNumber(idx);
        byte value = this.numberParser.parseByte(copy, this.len, 0);
        this.assertNoMoreJsonValues();
        return value;
    }

    byte getNonNullByte() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        return this.numberParser.parseByte(this.buffer, this.len, idx);
    }

    Byte getByte() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        if (this.buffer[idx] == 110) {
            this.visitRootNullAtom(idx);
            return null;
        }
        return this.numberParser.parseByte(this.buffer, this.len, idx);
    }

    short getRootNonNullShort() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        byte[] copy = this.padRootNumber(idx);
        short value = this.numberParser.parseShort(copy, this.len, 0);
        this.assertNoMoreJsonValues();
        return value;
    }

    Short getRootShort() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        if (this.buffer[idx] == 110) {
            this.visitRootNullAtom(idx);
            this.assertNoMoreJsonValues();
            return null;
        }
        byte[] copy = this.padRootNumber(idx);
        short value = this.numberParser.parseShort(copy, this.len, 0);
        this.assertNoMoreJsonValues();
        return value;
    }

    short getNonNullShort() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        return this.numberParser.parseShort(this.buffer, this.len, idx);
    }

    Short getShort() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        if (this.buffer[idx] == 110) {
            this.visitRootNullAtom(idx);
            return null;
        }
        return this.numberParser.parseShort(this.buffer, this.len, idx);
    }

    int getRootNonNullInt() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        byte[] copy = this.padRootNumber(idx);
        int value = this.numberParser.parseInt(copy, this.len, 0);
        this.assertNoMoreJsonValues();
        return value;
    }

    Integer getRootInt() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        if (this.buffer[idx] == 110) {
            this.visitRootNullAtom(idx);
            this.assertNoMoreJsonValues();
            return null;
        }
        byte[] copy = this.padRootNumber(idx);
        int value = this.numberParser.parseInt(copy, this.len, 0);
        this.assertNoMoreJsonValues();
        return value;
    }

    Integer getInt() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        if (this.buffer[idx] == 110) {
            this.visitRootNullAtom(idx);
            return null;
        }
        return this.numberParser.parseInt(this.buffer, this.len, idx);
    }

    int getNonNullInt() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        return this.numberParser.parseInt(this.buffer, this.len, idx);
    }

    long getRootNonNullLong() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        byte[] copy = this.padRootNumber(idx);
        long value = this.numberParser.parseLong(copy, this.len, 0);
        this.assertNoMoreJsonValues();
        return value;
    }

    Long getRootLong() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        if (this.buffer[idx] == 110) {
            this.visitRootNullAtom(idx);
            this.assertNoMoreJsonValues();
            return null;
        }
        byte[] copy = this.padRootNumber(idx);
        long value = this.numberParser.parseLong(copy, this.len, 0);
        this.assertNoMoreJsonValues();
        return value;
    }

    long getNonNullLong() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        return this.numberParser.parseLong(this.buffer, this.len, idx);
    }

    Long getLong() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        if (this.buffer[idx] == 110) {
            this.visitRootNullAtom(idx);
            return null;
        }
        return this.numberParser.parseLong(this.buffer, this.len, idx);
    }

    float getRootNonNullFloat() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        byte[] copy = this.padRootNumber(idx);
        float value = this.numberParser.parseFloat(copy, this.len, 0);
        this.assertNoMoreJsonValues();
        return value;
    }

    Float getRootFloat() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        if (this.buffer[idx] == 110) {
            this.visitRootNullAtom(idx);
            this.assertNoMoreJsonValues();
            return null;
        }
        byte[] copy = this.padRootNumber(idx);
        float value = this.numberParser.parseFloat(copy, this.len, 0);
        this.assertNoMoreJsonValues();
        return Float.valueOf(value);
    }

    double getRootNonNullDouble() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        byte[] copy = this.padRootNumber(idx);
        double value = this.numberParser.parseDouble(copy, this.len, 0);
        this.assertNoMoreJsonValues();
        return value;
    }

    Double getRootDouble() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        if (this.buffer[idx] == 110) {
            this.visitRootNullAtom(idx);
            this.assertNoMoreJsonValues();
            return null;
        }
        byte[] copy = this.padRootNumber(idx);
        double value = this.numberParser.parseDouble(copy, this.len, 0);
        this.assertNoMoreJsonValues();
        return value;
    }

    private byte[] padRootNumber(int idx) {
        int remainingLen = this.len - idx;
        byte[] copy = new byte[remainingLen + this.padding];
        System.arraycopy(this.buffer, idx, copy, 0, remainingLen);
        Arrays.fill(copy, remainingLen, remainingLen + this.padding, (byte)32);
        return copy;
    }

    double getNonNullDouble() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        return this.numberParser.parseDouble(this.buffer, this.len, idx);
    }

    Double getDouble() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        if (this.buffer[idx] == 110) {
            this.visitRootNullAtom(idx);
            return null;
        }
        return this.numberParser.parseDouble(this.buffer, this.len, idx);
    }

    float getNonNullFloat() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        return this.numberParser.parseFloat(this.buffer, this.len, idx);
    }

    Float getFloat() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        if (this.buffer[idx] == 110) {
            this.visitRootNullAtom(idx);
            return null;
        }
        return Float.valueOf(this.numberParser.parseFloat(this.buffer, this.len, idx));
    }

    int getRootString(byte[] stringBuffer) {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        int len = switch (this.buffer[idx]) {
            case 34 -> this.stringParser.parseString(this.buffer, idx, stringBuffer);
            case 110 -> {
                this.visitRootNullAtom(idx);
                yield -1;
            }
            default -> throw new JsonParsingException("Invalid value starting at " + idx + ". Expected either string or 'null'.");
        };
        this.assertNoMoreJsonValues();
        return len;
    }

    int getString(byte[] stringBuffer) {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        return switch (this.buffer[idx]) {
            case 34 -> this.stringParser.parseString(this.buffer, idx, stringBuffer);
            case 110 -> {
                this.visitNullAtom(idx);
                yield -1;
            }
            default -> throw new JsonParsingException("Invalid value starting at " + idx + ". Expected either string or 'null'.");
        };
    }

    char getNonNullChar() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        if (this.buffer[idx] == 34) {
            return this.stringParser.parseChar(this.buffer, idx);
        }
        throw new JsonParsingException("Invalid value starting at " + idx + ". Expected string.");
    }

    Character getChar() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        return switch (this.buffer[idx]) {
            case 34 -> Character.valueOf(this.stringParser.parseChar(this.buffer, idx));
            case 110 -> {
                this.visitNullAtom(idx);
                yield null;
            }
            default -> throw new JsonParsingException("Invalid value starting at " + idx + ". Expected either string or 'null'.");
        };
    }

    char getRootNonNullChar() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        if (this.buffer[idx] == 34) {
            char character = this.stringParser.parseChar(this.buffer, idx);
            this.assertNoMoreJsonValues();
            return character;
        }
        throw new JsonParsingException("Invalid value starting at " + idx + ". Expected string.");
    }

    Character getRootChar() {
        --this.depth;
        int idx = this.indexer.getAndAdvance();
        Character character = switch (this.buffer[idx]) {
            case 34 -> Character.valueOf(this.stringParser.parseChar(this.buffer, idx));
            case 110 -> {
                this.visitRootNullAtom(idx);
                yield null;
            }
            default -> throw new JsonParsingException("Invalid value starting at " + idx + ". Expected either string or 'null'.");
        };
        this.assertNoMoreJsonValues();
        return character;
    }

    IteratorResult startIteratingArray() {
        int idx = this.indexer.peek();
        if (this.buffer[idx] == 110) {
            this.visitNullAtom(idx);
            this.indexer.advance();
            --this.depth;
            return IteratorResult.NULL;
        }
        if (this.buffer[idx] != 91) {
            throw this.unexpectedCharException(idx, '[');
        }
        idx = this.indexer.advanceAndGet();
        if (this.buffer[idx] == 93) {
            this.indexer.advance();
            --this.depth;
            return IteratorResult.EMPTY;
        }
        ++this.depth;
        return IteratorResult.NOT_EMPTY;
    }

    IteratorResult startIteratingRootArray() {
        int idx = this.indexer.peek();
        if (this.buffer[idx] == 110) {
            this.visitRootNullAtom(idx);
            this.indexer.advance();
            --this.depth;
            return IteratorResult.NULL;
        }
        if (this.buffer[idx] != 91) {
            throw this.unexpectedCharException(idx, '[');
        }
        if (this.buffer[this.indexer.getLast()] != 93) {
            throw new JsonParsingException("Unclosed array. Missing ']' for starting '['.");
        }
        idx = this.indexer.advanceAndGet();
        if (this.buffer[idx] == 93) {
            this.indexer.advance();
            --this.depth;
            this.assertNoMoreJsonValues();
            return IteratorResult.EMPTY;
        }
        ++this.depth;
        return IteratorResult.NOT_EMPTY;
    }

    boolean nextArrayElement() {
        int idx = this.indexer.getAndAdvance();
        if (this.buffer[idx] == 93) {
            --this.depth;
            return false;
        }
        if (this.buffer[idx] == 44) {
            ++this.depth;
            return true;
        }
        throw new JsonParsingException("Missing comma between array values");
    }

    IteratorResult startIteratingObject() {
        int idx = this.indexer.peek();
        if (this.buffer[idx] == 110) {
            this.visitNullAtom(idx);
            this.indexer.advance();
            --this.depth;
            return IteratorResult.NULL;
        }
        if (this.buffer[idx] != 123) {
            throw this.unexpectedCharException(idx, '{');
        }
        idx = this.indexer.advanceAndGet();
        if (this.buffer[idx] == 125) {
            this.indexer.advance();
            --this.depth;
            return IteratorResult.EMPTY;
        }
        return IteratorResult.NOT_EMPTY;
    }

    IteratorResult startIteratingRootObject() {
        int idx = this.indexer.peek();
        if (this.buffer[idx] == 110) {
            this.visitRootNullAtom(idx);
            this.indexer.advance();
            --this.depth;
            return IteratorResult.NULL;
        }
        if (this.buffer[idx] != 123) {
            throw this.unexpectedCharException(idx, '{');
        }
        if (this.buffer[this.indexer.getLast()] != 125) {
            throw new JsonParsingException("Unclosed object. Missing '}' for starting '{'.");
        }
        idx = this.indexer.advanceAndGet();
        if (this.buffer[idx] == 125) {
            this.indexer.advance();
            --this.depth;
            this.assertNoMoreJsonValues();
            return IteratorResult.EMPTY;
        }
        return IteratorResult.NOT_EMPTY;
    }

    boolean nextObjectField() {
        int idx = this.indexer.getAndAdvance();
        byte character = this.buffer[idx];
        if (character == 125) {
            --this.depth;
            return false;
        }
        if (character == 44) {
            return true;
        }
        throw this.unexpectedCharException(idx, ',');
    }

    void moveToFieldValue() {
        int idx = this.indexer.getAndAdvance();
        if (this.buffer[idx] != 58) {
            throw this.unexpectedCharException(idx, ':');
        }
        ++this.depth;
    }

    int getFieldName(byte[] stringBuffer) {
        int idx = this.indexer.getAndAdvance();
        if (this.buffer[idx] != 34) {
            throw this.unexpectedCharException(idx, '\"');
        }
        return this.stringParser.parseString(this.buffer, idx, stringBuffer);
    }

    int getDepth() {
        return this.depth;
    }

    private JsonParsingException unexpectedCharException(int idx, char expected) {
        if (this.indexer.isPastEnd()) {
            return new JsonParsingException("Expected '" + expected + "' but reached end of buffer.");
        }
        return new JsonParsingException("Expected '" + expected + "' but got: '" + (char)this.buffer[idx] + "'.");
    }

    void assertNoMoreJsonValues() {
        if (this.indexer.hasNext()) {
            throw new JsonParsingException("More than one JSON value at the root of the document, or extra characters at the end of the JSON!");
        }
    }

    static {
        Arrays.fill(SKIP_DEPTH_PER_CHARACTER, 0);
        OnDemandJsonIterator.SKIP_DEPTH_PER_CHARACTER[91] = 1;
        OnDemandJsonIterator.SKIP_DEPTH_PER_CHARACTER[123] = 1;
        OnDemandJsonIterator.SKIP_DEPTH_PER_CHARACTER[93] = -1;
        OnDemandJsonIterator.SKIP_DEPTH_PER_CHARACTER[125] = -1;
    }

    static enum IteratorResult {
        EMPTY,
        NULL,
        NOT_EMPTY;

    }
}

